/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record TimeSpan(long startMillis, long startNanos, long stopMillis, long stopNanos) implements Writeable,
ToXContentObject
{
    public static TimeSpan readFrom(StreamInput in) throws IOException {
        return new TimeSpan(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.startMillis);
        out.writeVLong(this.startNanos);
        out.writeVLong(this.stopMillis);
        out.writeVLong(this.stopNanos);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timestampFieldsFromUnixEpochMillis("start_millis", "start", this.startMillis);
        builder.timestampFieldsFromUnixEpochMillis("stop_millis", "stop", this.stopMillis);
        if (builder.humanReadable()) {
            builder.field("took_time", (Object)this.toTimeValue());
        }
        builder.field("took_millis", this.durationInMillis());
        builder.field("took_nanos", this.durationInNanos());
        builder.endObject();
        return builder;
    }

    public TimeValue toTimeValue() {
        return TimeValue.timeValueNanos((long)(this.stopNanos - this.startNanos));
    }

    public long durationInMillis() {
        return this.stopMillis - this.startMillis;
    }

    public long durationInNanos() {
        return this.stopNanos - this.startNanos;
    }

    public static Builder start() {
        return new Builder();
    }

    public static class Builder {
        private final long startMillis = System.currentTimeMillis();
        private final long startNanos = System.nanoTime();

        public TimeSpan stop() {
            return new TimeSpan(this.startMillis, this.startNanos, System.currentTimeMillis(), System.nanoTime());
        }
    }
}

