/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.stringstats;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregatorFactory;
import org.elasticsearch.xpack.analytics.stringstats.StringStatsAggregatorSupplier;

public class StringStatsAggregationBuilder
extends ValuesSourceAggregationBuilder<StringStatsAggregationBuilder> {
    public static final String NAME = "string_stats";
    public static final ValuesSourceRegistry.RegistryKey<StringStatsAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey("string_stats", StringStatsAggregatorSupplier.class);
    private static final ParseField SHOW_DISTRIBUTION_FIELD = new ParseField("show_distribution", new String[0]);
    public static final ObjectParser<StringStatsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"string_stats", StringStatsAggregationBuilder::new);
    private boolean showDistribution = false;

    public StringStatsAggregationBuilder(String name) {
        super(name);
    }

    public StringStatsAggregationBuilder(StringStatsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.showDistribution = clone.showDistribution();
    }

    public StringStatsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.showDistribution = in.readBoolean();
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.KEYWORD;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new StringStatsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.showDistribution);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected StringStatsAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        StringStatsAggregatorSupplier aggregatorSupplier = (StringStatsAggregatorSupplier)context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        return new StringStatsAggregatorFactory(this.name, config, this.showDistribution, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(SHOW_DISTRIBUTION_FIELD.getPreferredName(), this.showDistribution);
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public boolean showDistribution() {
        return this.showDistribution;
    }

    public StringStatsAggregationBuilder showDistribution(boolean showDistribution) {
        this.showDistribution = showDistribution;
        return this;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        StringStatsAggregatorFactory.registerAggregators(builder);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.showDistribution);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StringStatsAggregationBuilder other = (StringStatsAggregationBuilder)((Object)obj);
        return this.showDistribution == other.showDistribution;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, (boolean)true, (boolean)true, (boolean)false);
        PARSER.declareBoolean(StringStatsAggregationBuilder::showDistribution, SHOW_DISTRIBUTION_FIELD);
    }
}

