/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.xpack.analytics.mapper.ExponentialHistogramParser;
import org.elasticsearch.xpack.analytics.mapper.HistogramParser;
import org.elasticsearch.xpack.analytics.mapper.IndexWithCount;

public class ParsedHistogramConverter {
    public static HistogramParser.ParsedHistogram exponentialToTDigest(ExponentialHistogramParser.ParsedExponentialHistogram expHisto) {
        ArrayList<Double> centroids = new ArrayList<Double>();
        ArrayList<Long> counts = new ArrayList<Long>();
        List<IndexWithCount> neg = expHisto.negativeBuckets();
        for (int i = neg.size() - 1; i >= 0; --i) {
            ParsedHistogramConverter.appendBucketCentroid(centroids, counts, neg.get(i), expHisto.scale(), -1);
        }
        if (expHisto.zeroCount() > 0L) {
            centroids.add(0.0);
            counts.add(expHisto.zeroCount());
        }
        for (IndexWithCount positiveBucket : expHisto.positiveBuckets()) {
            ParsedHistogramConverter.appendBucketCentroid(centroids, counts, positiveBucket, expHisto.scale(), 1);
        }
        assert (centroids.size() == counts.size());
        assert (centroids.stream().sorted().toList().equals(centroids));
        return new HistogramParser.ParsedHistogram(centroids, counts);
    }

    public static ExponentialHistogramParser.ParsedExponentialHistogram tDigestToExponential(HistogramParser.ParsedHistogram tDigest) {
        int numNegativeCentroids;
        List<Double> centroids = tDigest.values();
        List<Long> counts = tDigest.counts();
        for (numNegativeCentroids = 0; numNegativeCentroids < centroids.size() && centroids.get(numNegativeCentroids) < 0.0; ++numNegativeCentroids) {
        }
        int scale = 38;
        ArrayList<IndexWithCount> negativeBuckets = new ArrayList<IndexWithCount>();
        for (int i = numNegativeCentroids - 1; i >= 0; --i) {
            double centroid = centroids.get(i);
            long count = counts.get(i);
            assert (centroid < 0.0);
            ParsedHistogramConverter.appendCentroidWithCountAsBucket(centroid, count, scale, negativeBuckets);
        }
        long zeroCount = 0L;
        int firstPositiveIndex = numNegativeCentroids;
        if (firstPositiveIndex < centroids.size() && centroids.get(firstPositiveIndex) == 0.0) {
            zeroCount = counts.get(firstPositiveIndex);
            ++firstPositiveIndex;
        }
        ArrayList<IndexWithCount> positiveBuckets = new ArrayList<IndexWithCount>();
        for (int i = firstPositiveIndex; i < centroids.size(); ++i) {
            double centroid = centroids.get(i);
            long count = counts.get(i);
            assert (centroid > 0.0);
            ParsedHistogramConverter.appendCentroidWithCountAsBucket(centroid, count, scale, positiveBuckets);
        }
        return new ExponentialHistogramParser.ParsedExponentialHistogram(scale, 0.0, zeroCount, negativeBuckets, positiveBuckets, null, null, null);
    }

    private static void appendCentroidWithCountAsBucket(double centroid, long count, int scale, List<IndexWithCount> outputBuckets) {
        if (count == 0L) {
            return;
        }
        long index = ExponentialScaleUtils.computeIndex((double)centroid, (int)scale);
        assert (outputBuckets.isEmpty() || outputBuckets.getLast().index() < index);
        outputBuckets.add(new IndexWithCount(index, count));
    }

    private static void appendBucketCentroid(List<Double> centroids, List<Long> counts, IndexWithCount expHistoBucket, int scale, int sign) {
        double lowerBound = ExponentialScaleUtils.getLowerBucketBoundary((long)expHistoBucket.index(), (int)scale);
        double upperBound = ExponentialScaleUtils.getUpperBucketBoundary((long)expHistoBucket.index(), (int)scale);
        double center = (double)sign * (lowerBound + upperBound) / 2.0;
        if (!centroids.isEmpty() && centroids.getLast() == center) {
            counts.add(counts.removeLast() + expHistoBucket.count());
        } else {
            centroids.add(center);
            counts.add(expHistoBucket.count());
        }
    }
}

