/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreSettings;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamsAction
extends TransportLocalProjectMetadataAction<GetDataStreamAction.Request, GetDataStreamAction.Response> {
    private static final Logger LOGGER = LogManager.getLogger(TransportGetDataStreamsAction.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ClusterSettings clusterSettings;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;
    private final DataStreamFailureStoreSettings dataStreamFailureStoreSettings;
    private final IndexSettingProviders indexSettingProviders;
    private final Client client;
    private final MetadataDataStreamsService metadataDataStreamsService;

    @Inject
    public TransportGetDataStreamsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, DataStreamGlobalRetentionSettings globalRetentionSettings, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, IndexSettingProviders indexSettingProviders, Client client, MetadataDataStreamsService metadataDataStreamsService) {
        super("indices:admin/data_stream/get", actionFilters, transportService.getTaskManager(), clusterService, (Executor)threadPool.executor("management"), projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.globalRetentionSettings = globalRetentionSettings;
        this.clusterSettings = clusterService.getClusterSettings();
        this.dataStreamFailureStoreSettings = dataStreamFailureStoreSettings;
        this.indexSettingProviders = indexSettingProviders;
        this.client = new OriginSettingClient(client, "stack");
        this.metadataDataStreamsService = metadataDataStreamsService;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetDataStreamAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(final Task task, final GetDataStreamAction.Request request, final ProjectState state, final ActionListener<GetDataStreamAction.Response> listener) throws Exception {
        ((CancellableTask)task).ensureNotCancelled();
        if (request.verbose()) {
            DataStreamsStatsAction.Request req = new DataStreamsStatsAction.Request();
            req.indices(request.indices());
            this.client.execute((ActionType)DataStreamsStatsAction.INSTANCE, (ActionRequest)req, (ActionListener)new ActionListener<DataStreamsStatsAction.Response>(){

                public void onResponse(DataStreamsStatsAction.Response response) {
                    ((CancellableTask)task).ensureNotCancelled();
                    Map<String, Long> maxTimestamps = Arrays.stream(response.getDataStreams()).collect(Collectors.toMap(DataStreamsStatsAction.DataStreamStats::getDataStream, DataStreamsStatsAction.DataStreamStats::getMaximumTimestamp));
                    listener.onResponse((Object)TransportGetDataStreamsAction.innerOperation(state, request, TransportGetDataStreamsAction.this.indexNameExpressionResolver, TransportGetDataStreamsAction.this.systemIndices, TransportGetDataStreamsAction.this.clusterSettings, TransportGetDataStreamsAction.this.globalRetentionSettings, TransportGetDataStreamsAction.this.dataStreamFailureStoreSettings, TransportGetDataStreamsAction.this.indexSettingProviders, maxTimestamps, TransportGetDataStreamsAction.this.metadataDataStreamsService));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            listener.onResponse((Object)TransportGetDataStreamsAction.innerOperation(state, request, this.indexNameExpressionResolver, this.systemIndices, this.clusterSettings, this.globalRetentionSettings, this.dataStreamFailureStoreSettings, this.indexSettingProviders, null, this.metadataDataStreamsService));
        }
    }

    @Nullable
    static IndexMode resolveMode(ProjectState state, IndexSettingProviders indexSettingProviders, DataStream dataStream, Settings settings, ComposableIndexTemplate indexTemplate) {
        String rawMode;
        IndexMode indexMode = state.metadata().retrieveIndexModeFromTemplate(indexTemplate);
        IndexVersion indexVersion = state.metadata().index(dataStream.getWriteIndex()).getCreationVersion();
        for (IndexSettingProvider provider : indexSettingProviders.getIndexSettingProviders()) {
            Settings.Builder builder = Settings.builder();
            provider.provideAdditionalSettings("validate-index-name", dataStream.getName(), indexMode, state.metadata(), Instant.now(), settings, List.of(), indexVersion, builder);
            Settings addlSettings = builder.build();
            String rawMode2 = addlSettings.get(IndexSettings.MODE.getKey());
            if (rawMode2 == null) continue;
            indexMode = Enum.valueOf(IndexMode.class, rawMode2.toUpperCase(Locale.ROOT));
        }
        if (indexMode == null && (rawMode = settings.get(IndexSettings.MODE.getKey())) != null) {
            indexMode = Enum.valueOf(IndexMode.class, rawMode.toUpperCase(Locale.ROOT));
        }
        return indexMode;
    }

    static GetDataStreamAction.Response innerOperation(ProjectState state, GetDataStreamAction.Request request, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, ClusterSettings clusterSettings, DataStreamGlobalRetentionSettings globalRetentionSettings, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, IndexSettingProviders indexSettingProviders, @Nullable Map<String, Long> maxTimestamps, MetadataDataStreamsService metadataDataStreamsService) {
        List<DataStream> dataStreams = TransportGetDataStreamsAction.getDataStreams(state.metadata(), indexNameExpressionResolver, request);
        ArrayList<GetDataStreamAction.Response.DataStreamInfo> dataStreamInfos = new ArrayList<GetDataStreamAction.Response.DataStreamInfo>(dataStreams.size());
        for (DataStream dataStream : dataStreams) {
            String indexTemplate;
            boolean failureStoreEffectivelyEnabled = dataStream.isFailureStoreEffectivelyEnabled(dataStreamFailureStoreSettings);
            boolean indexTemplatePreferIlmValue = true;
            String ilmPolicyName = null;
            IndexMode indexMode = dataStream.getIndexMode();
            if (dataStream.isSystem()) {
                SystemDataStreamDescriptor dataStreamDescriptor = systemIndices.findMatchingDataStreamDescriptor(dataStream.getName());
                String string = indexTemplate = dataStreamDescriptor != null ? dataStreamDescriptor.getDataStreamName() : null;
                if (dataStreamDescriptor != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings((ComposableIndexTemplate)dataStreamDescriptor.getComposableIndexTemplate(), (Map)dataStreamDescriptor.getComponentTemplates());
                    ilmPolicyName = settings.get("index.lifecycle.name");
                    if (indexMode == null) {
                        indexMode = TransportGetDataStreamsAction.resolveMode(state, indexSettingProviders, dataStream, settings, dataStreamDescriptor.getComposableIndexTemplate());
                    }
                    indexTemplatePreferIlmValue = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(settings);
                }
            } else {
                indexTemplate = MetadataIndexTemplateService.findV2Template((ProjectMetadata)state.metadata(), (String)dataStream.getName(), (boolean)false);
                if (indexTemplate != null) {
                    Settings settings;
                    try {
                        settings = metadataDataStreamsService.getEffectiveSettings(state.metadata(), dataStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to get effective settings for data stream: " + dataStream.getName(), e);
                    }
                    ilmPolicyName = settings.get("index.lifecycle.name");
                    if (indexMode == null && state.metadata().templatesV2().get(indexTemplate) != null) {
                        try {
                            indexMode = TransportGetDataStreamsAction.resolveMode(state, indexSettingProviders, dataStream, settings, dataStream.getEffectiveIndexTemplate(state.metadata()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to determine indexMode for data stream: " + dataStream.getName(), e);
                        }
                    }
                    indexTemplatePreferIlmValue = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(settings);
                } else {
                    LOGGER.warn("couldn't find any matching template for data stream [{}]. has it been restored (and possibly renamed)from a snapshot?", (Object)dataStream.getName());
                }
            }
            ClusterStateHealth streamHealth = new ClusterStateHealth(state.cluster(), (String[])dataStream.getIndices().stream().map(Index::getName).toArray(String[]::new), state.projectId());
            HashMap<Index, GetDataStreamAction.Response.IndexProperties> backingIndicesSettingsValues = new HashMap<Index, GetDataStreamAction.Response.IndexProperties>();
            ProjectMetadata metadata = state.metadata();
            TransportGetDataStreamsAction.collectIndexSettingsValues(dataStream, backingIndicesSettingsValues, metadata, dataStream.getIndices());
            if (!dataStream.getFailureIndices().isEmpty()) {
                TransportGetDataStreamsAction.collectIndexSettingsValues(dataStream, backingIndicesSettingsValues, metadata, dataStream.getFailureIndices());
            }
            GetDataStreamAction.Response.TimeSeries timeSeries = null;
            if (dataStream.getIndexMode() == IndexMode.TIME_SERIES) {
                ArrayList<Tuple> mergedRanges = new ArrayList<Tuple>();
                Tuple currentMergedRange = null;
                record IndexInfo(String name, Instant timeSeriesStart, Instant timeSeriesEnd) implements Comparable<IndexInfo>
                {
                    @Override
                    public int compareTo(IndexInfo o) {
                        return Comparator.comparing(IndexInfo::timeSeriesStart).thenComparing(IndexInfo::timeSeriesEnd).compare(this, o);
                    }
                }
                IndexInfo previous = null;
                List<IndexInfo> sortedRanges = dataStream.getIndices().stream().map(arg_0 -> ((ProjectMetadata)metadata).index(arg_0)).filter(m -> m.getIndexMode() == IndexMode.TIME_SERIES).map(m -> new IndexInfo(m.getIndex().getName(), m.getTimeSeriesStart(), m.getTimeSeriesEnd())).sorted().toList();
                for (IndexInfo info : sortedRanges) {
                    Instant start = info.timeSeriesStart();
                    Instant end = info.timeSeriesEnd();
                    if (currentMergedRange == null) {
                        currentMergedRange = new Tuple((Object)start, (Object)end);
                    } else if (((Instant)currentMergedRange.v2()).compareTo(start) == 0) {
                        currentMergedRange = new Tuple((Object)((Instant)currentMergedRange.v1()), (Object)end);
                    } else if (((Instant)currentMergedRange.v2()).compareTo(start) < 0) {
                        mergedRanges.add(currentMergedRange);
                        currentMergedRange = new Tuple((Object)start, (Object)end);
                    } else {
                        String message = "previous backing index [" + previous.name() + "] range [" + String.valueOf(previous.timeSeriesStart()) + "/" + String.valueOf(previous.timeSeriesEnd()) + "] range is colliding with current backing [" + info.name() + "] index range [" + String.valueOf(start) + "/" + String.valueOf(end) + "]";
                        assert (((Instant)currentMergedRange.v2()).compareTo(start) < 0) : message;
                    }
                    previous = info;
                }
                if (currentMergedRange != null) {
                    mergedRanges.add(currentMergedRange);
                }
                timeSeries = new GetDataStreamAction.Response.TimeSeries(mergedRanges);
            }
            dataStreamInfos.add(new GetDataStreamAction.Response.DataStreamInfo(dataStream, failureStoreEffectivelyEnabled, streamHealth.getStatus(), indexTemplate, ilmPolicyName, timeSeries, backingIndicesSettingsValues, indexTemplatePreferIlmValue, maxTimestamps == null ? null : maxTimestamps.get(dataStream.getName()), indexMode == null ? IndexMode.STANDARD.getName() : indexMode.getName()));
        }
        return new GetDataStreamAction.Response(dataStreamInfos, request.includeDefaults() ? (RolloverConfiguration)clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING) : null, globalRetentionSettings.get(false), globalRetentionSettings.get(true));
    }

    private static void collectIndexSettingsValues(DataStream dataStream, Map<Index, GetDataStreamAction.Response.IndexProperties> backingIndicesSettingsValues, ProjectMetadata metadata, List<Index> backingIndices) {
        for (Index index : backingIndices) {
            IndexMetadata indexMetadata = metadata.index(index);
            Boolean preferIlm = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings());
            assert (preferIlm != null) : "must use the default prefer ilm setting value, if nothing else";
            GetDataStreamAction.Response.ManagedBy managedBy = metadata.isIndexManagedByILM(indexMetadata) ? GetDataStreamAction.Response.ManagedBy.ILM : (dataStream.isIndexManagedByDataStreamLifecycle(index, arg_0 -> ((ProjectMetadata)metadata).index(arg_0)) ? GetDataStreamAction.Response.ManagedBy.LIFECYCLE : GetDataStreamAction.Response.ManagedBy.UNMANAGED);
            String indexMode = ((IndexMode)IndexSettings.MODE.get(indexMetadata.getSettings())).getName();
            backingIndicesSettingsValues.put(index, new GetDataStreamAction.Response.IndexProperties(preferIlm.booleanValue(), indexMetadata.getLifecyclePolicyName(), managedBy, indexMode));
        }
    }

    static List<DataStream> getDataStreams(ProjectMetadata project, IndexNameExpressionResolver iner, GetDataStreamAction.Request request) {
        List results = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)iner, (ProjectMetadata)project, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = project.dataStreams();
        return results.stream().map(dataStreams::get).sorted(Comparator.comparing(DataStream::getName)).toList();
    }

    protected ClusterBlockException checkBlock(GetDataStreamAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

