/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.exponentialhistogram.aggregations.support.ExponentialHistogramValuesSource;
import org.elasticsearch.xpack.exponentialhistogram.fielddata.ExponentialHistogramValuesReader;

public final class ExponentialHistogramBackedHistogramAggregator
extends AbstractHistogramAggregator {
    private final ExponentialHistogramValuesSource.ExponentialHistogram valuesSource;

    public ExponentialHistogramBackedHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, interval, offset, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig.format(), context, parent, cardinalityUpperBound, metadata);
        this.valuesSource = (ExponentialHistogramValuesSource.ExponentialHistogram)valuesSourceConfig.getValuesSource();
        if (this.subAggregators().length > 0) {
            throw new IllegalArgumentException("Histogram aggregation on histogram fields does not support sub-aggregations");
        }
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final ExponentialHistogramValuesReader values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    ExponentialHistogram histo = values.histogramValue();
                    ExponentialHistogramBackedHistogramAggregator.forEachBucketCenter(histo, (center, count) -> {
                        double key = Math.floor((center - ExponentialHistogramBackedHistogramAggregator.this.offset) / ExponentialHistogramBackedHistogramAggregator.this.interval);
                        if (ExponentialHistogramBackedHistogramAggregator.this.hardBounds == null || ExponentialHistogramBackedHistogramAggregator.this.hardBounds.contain(key * ExponentialHistogramBackedHistogramAggregator.this.interval)) {
                            long bucketOrd = ExponentialHistogramBackedHistogramAggregator.this.bucketOrds.add(owningBucketOrd, Double.doubleToLongBits(key));
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                ExponentialHistogramBackedHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                ExponentialHistogramBackedHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                            }
                            ExponentialHistogramBackedHistogramAggregator.this.incrementBucketDocCount(bucketOrd, count - (long)ExponentialHistogramBackedHistogramAggregator.this.docCountProvider.getDocCount(doc));
                        }
                    });
                }
            }
        };
    }

    private static void forEachBucketCenter(ExponentialHistogram histo, BucketCenterConsumer consumer) throws IOException {
        CopyableBucketIterator negIt = histo.negativeBuckets().iterator();
        while (negIt.hasNext()) {
            double center = -ExponentialScaleUtils.getPointOfLeastRelativeError((long)negIt.peekIndex(), (int)negIt.scale());
            center = Math.clamp(center, histo.min(), histo.max());
            consumer.accept(center, negIt.peekCount());
            negIt.advance();
        }
        if (histo.zeroBucket().count() > 0L) {
            consumer.accept(0.0, histo.zeroBucket().count());
        }
        CopyableBucketIterator posIt = histo.positiveBuckets().iterator();
        while (posIt.hasNext()) {
            double center = ExponentialScaleUtils.getPointOfLeastRelativeError((long)posIt.peekIndex(), (int)posIt.scale());
            center = Math.clamp(center, histo.min(), histo.max());
            consumer.accept(center, posIt.peekCount());
            posIt.advance();
        }
    }

    @FunctionalInterface
    private static interface BucketCenterConsumer {
        public void accept(double var1, long var3) throws IOException;
    }
}

