/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIRequest;

public class VoyageAIEmbeddingsRequest
extends VoyageAIRequest {
    private final List<String> input;
    private final InputType inputType;
    private final VoyageAIEmbeddingsModel embeddingsModel;

    public VoyageAIEmbeddingsRequest(List<String> input, InputType inputType, VoyageAIEmbeddingsModel embeddingsModel) {
        this.embeddingsModel = Objects.requireNonNull(embeddingsModel);
        this.input = Objects.requireNonNull(input);
        this.inputType = inputType;
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.embeddingsModel.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new VoyageAIEmbeddingsRequestEntity(this.input, this.inputType, this.embeddingsModel.getServiceSettings(), this.embeddingsModel.getTaskSettings(), this.embeddingsModel.getServiceSettings().modelId())).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        VoyageAIEmbeddingsRequest.decorateWithHeaders(httpPost, this.embeddingsModel);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.embeddingsModel.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.embeddingsModel.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    public VoyageAIEmbeddingsServiceSettings getServiceSettings() {
        return this.embeddingsModel.getServiceSettings();
    }
}

