/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.model;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerServiceSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerTaskSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemas;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredServiceSchema;

public class SageMakerModelBuilder {
    private final SageMakerSchemas schemas;

    public SageMakerModelBuilder(SageMakerSchemas schemas) {
        this.schemas = schemas;
    }

    public SageMakerModel fromRequest(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> requestMap) {
        ValidationException validationException = new ValidationException();
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(requestMap, "service_settings");
        AwsSecretSettings awsSecretSettings = AwsSecretSettings.fromMap(serviceSettingsMap);
        SageMakerServiceSettings serviceSettings = SageMakerServiceSettings.fromMap(this.schemas, taskType, serviceSettingsMap);
        SageMakerSchema schema = this.schemas.schemaFor(taskType, serviceSettings.api());
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(requestMap, "task_settings");
        SageMakerTaskSettings taskSettings = SageMakerTaskSettings.fromMap(taskSettingsMap, schema.apiTaskSettings(taskSettingsMap, validationException), validationException);
        validationException.throwIfValidationErrorsExist();
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, service);
        ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, service);
        ModelConfigurations modelConfigurations = new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings);
        return new SageMakerModel(modelConfigurations, new ModelSecrets((SecretSettings)awsSecretSettings), serviceSettings, taskSettings, awsSecretSettings);
    }

    public SageMakerModel fromStorage(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> config, Map<String, Object> secrets) {
        ValidationException validationException = new ValidationException();
        AwsSecretSettings awsSecretSettings = secrets != null ? AwsSecretSettings.fromMap(ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings")) : null;
        SageMakerServiceSettings serviceSettings = SageMakerServiceSettings.fromMap(this.schemas, taskType, ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings"));
        SageMakerSchema schema = this.schemas.schemaFor(taskType, serviceSettings.api());
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "task_settings");
        SageMakerTaskSettings taskSettings = SageMakerTaskSettings.fromMap(taskSettingsMap, schema.apiTaskSettings(taskSettingsMap, validationException), validationException);
        validationException.throwIfValidationErrorsExist();
        ServiceUtils.throwIfNotEmptyMap(config, service);
        ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, service);
        ServiceUtils.throwIfNotEmptyMap(secrets, service);
        ModelConfigurations modelConfigurations = new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings);
        return new SageMakerModel(modelConfigurations, new ModelSecrets((SecretSettings)awsSecretSettings), serviceSettings, taskSettings, awsSecretSettings);
    }

    public SageMakerModel updateModelWithEmbeddingDetails(SageMakerModel model, int embeddingSize) {
        SageMakerStoredServiceSchema updatedApiServiceSettings = model.apiServiceSettings().updateModelWithEmbeddingDetails(embeddingSize);
        if (updatedApiServiceSettings == model.apiServiceSettings()) {
            return model;
        }
        SageMakerServiceSettings updatedServiceSettings = new SageMakerServiceSettings(model.serviceSettings().endpointName(), model.serviceSettings().region(), model.serviceSettings().api(), model.serviceSettings().targetModel(), model.serviceSettings().targetContainerHostname(), model.serviceSettings().inferenceComponentName(), model.serviceSettings().batchSize(), updatedApiServiceSettings);
        ModelConfigurations modelConfigurations = new ModelConfigurations(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), (ServiceSettings)updatedServiceSettings, (TaskSettings)model.taskSettings());
        return new SageMakerModel(modelConfigurations, model.getSecrets(), updatedServiceSettings, model.taskSettings(), model.awsSecretSettings().orElse(null));
    }
}

