/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiUtils;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class OpenShiftAiServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    protected static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(3000L);
    protected final String modelId;
    protected final URI uri;
    protected final RateLimitSettings rateLimitSettings;

    protected OpenShiftAiServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readOptionalString();
        this.uri = ServiceUtils.createUri(in.readString());
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    protected OpenShiftAiServiceSettings(@Nullable String modelId, URI uri, @Nullable RateLimitSettings rateLimitSettings) {
        this.modelId = modelId;
        this.uri = Objects.requireNonNull(uri);
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return OpenShiftAiUtils.ML_INFERENCE_OPENSHIFT_AI_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return OpenShiftAiUtils.supportsOpenShiftAi(version);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.modelId);
        out.writeString(this.uri.toString());
        this.rateLimitSettings.writeTo(out);
    }

    public String modelId() {
        return this.modelId;
    }

    public URI uri() {
        return this.uri;
    }

    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.modelId != null) {
            builder.field("model_id", this.modelId);
        }
        builder.field("url", this.uri.toString());
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    protected static <T extends OpenShiftAiServiceSettings> T fromMap(Map<String, Object> map, ConfigurationParseContext context, Function<OpenShiftAiCommonServiceSettings, T> factory) {
        ValidationException validationException = new ValidationException();
        OpenShiftAiCommonServiceSettings commonServiceSettings = OpenShiftAiServiceSettings.extractOpenShiftAiCommonServiceSettings(map, context, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return (T)((OpenShiftAiServiceSettings)factory.apply(commonServiceSettings));
    }

    protected static OpenShiftAiCommonServiceSettings extractOpenShiftAiCommonServiceSettings(Map<String, Object> map, ConfigurationParseContext context, ValidationException validationException) {
        String model = ServiceUtils.extractOptionalString(map, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.extractUri(map, "url", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "openshift_ai", context);
        return new OpenShiftAiCommonServiceSettings(model, uri, rateLimitSettings);
    }

    protected record OpenShiftAiCommonServiceSettings(String model, URI uri, RateLimitSettings rateLimitSettings) {
    }
}

