/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class ElasticsearchInternalServiceSettings
implements ServiceSettings {
    public static final String NAME = "text_embedding_internal_service_settings";
    private static final int FAILED_INT_PARSE_VALUE = -1;
    public static final String NUM_ALLOCATIONS = "num_allocations";
    public static final String NUM_THREADS = "num_threads";
    public static final String MODEL_ID = "model_id";
    public static final String DEPLOYMENT_ID = "deployment_id";
    public static final String ADAPTIVE_ALLOCATIONS = "adaptive_allocations";
    private Integer numAllocations;
    private final int numThreads;
    private final String modelId;
    private AdaptiveAllocationsSettings adaptiveAllocationsSettings;
    private final String deploymentId;

    public static ElasticsearchInternalServiceSettings fromPersistedMap(Map<String, Object> map) {
        return ElasticsearchInternalServiceSettings.fromRequestMap(map).build();
    }

    public static Builder fromRequestMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Builder builder = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return builder;
    }

    protected static Builder fromMap(Map<String, Object> map, ValidationException validationException) {
        Integer numAllocations = ServiceUtils.extractOptionalPositiveInteger(map, NUM_ALLOCATIONS, "service_settings", validationException);
        Integer numThreads = ServiceUtils.extractRequiredPositiveInteger(map, NUM_THREADS, "service_settings", validationException);
        AdaptiveAllocationsSettings adaptiveAllocationsSettings = ServiceUtils.removeAsAdaptiveAllocationsSettings(map, ADAPTIVE_ALLOCATIONS, validationException);
        String modelId = ServiceUtils.extractOptionalString(map, MODEL_ID, "service_settings", validationException);
        if (numAllocations == null && adaptiveAllocationsSettings == null) {
            validationException.addValidationError(ServiceUtils.missingOneOfSettingsErrorMsg(List.of(NUM_ALLOCATIONS, ADAPTIVE_ALLOCATIONS), "service_settings"));
        }
        String deploymentId = ServiceUtils.extractOptionalString(map, DEPLOYMENT_ID, "service_settings", validationException);
        return new Builder().setNumAllocations(numAllocations).setNumThreads(Objects.requireNonNullElse(numThreads, -1)).setModelId(modelId).setAdaptiveAllocationsSettings(adaptiveAllocationsSettings).setDeploymentId(deploymentId);
    }

    public ElasticsearchInternalServiceSettings(@Nullable Integer numAllocations, int numThreads, String modelId, @Nullable AdaptiveAllocationsSettings adaptiveAllocationsSettings, @Nullable String deploymentId) {
        this.numAllocations = numAllocations;
        this.numThreads = numThreads;
        this.modelId = Objects.requireNonNull(modelId);
        this.adaptiveAllocationsSettings = adaptiveAllocationsSettings;
        this.deploymentId = deploymentId;
    }

    protected ElasticsearchInternalServiceSettings(ElasticsearchInternalServiceSettings other) {
        this.numAllocations = other.numAllocations;
        this.numThreads = other.numThreads;
        this.modelId = other.modelId;
        this.adaptiveAllocationsSettings = other.adaptiveAllocationsSettings;
        this.deploymentId = other.deploymentId;
    }

    public ElasticsearchInternalServiceSettings(ElasticsearchInternalServiceSettings other, int numAllocations) {
        this.numAllocations = numAllocations;
        this.numThreads = other.numThreads;
        this.modelId = other.modelId;
        this.adaptiveAllocationsSettings = other.adaptiveAllocationsSettings;
        this.deploymentId = other.deploymentId;
    }

    public ElasticsearchInternalServiceSettings(StreamInput in) throws IOException {
        this.numAllocations = in.readOptionalVInt();
        this.numThreads = in.readVInt();
        this.modelId = in.readString();
        this.adaptiveAllocationsSettings = (AdaptiveAllocationsSettings)in.readOptionalWriteable(AdaptiveAllocationsSettings::new);
        this.deploymentId = in.readOptionalString();
    }

    public void setAllocations(Integer numAllocations, @Nullable AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
        this.numAllocations = numAllocations;
        this.adaptiveAllocationsSettings = adaptiveAllocationsSettings;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.getNumAllocations());
        out.writeVInt(this.getNumThreads());
        out.writeString(this.modelId());
        out.writeOptionalWriteable((Writeable)this.getAdaptiveAllocationsSettings());
        out.writeOptionalString(this.deploymentId);
    }

    public String modelId() {
        return this.modelId;
    }

    public String deloymentId() {
        return this.modelId;
    }

    public Integer getNumAllocations() {
        return this.numAllocations;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public AdaptiveAllocationsSettings getAdaptiveAllocationsSettings() {
        return this.adaptiveAllocationsSettings;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addInternalSettingsToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected void addInternalSettingsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.numAllocations != null) {
            builder.field(NUM_ALLOCATIONS, this.numAllocations);
        }
        builder.field(NUM_THREADS, this.getNumThreads());
        builder.field(MODEL_ID, this.modelId());
        if (this.adaptiveAllocationsSettings != null) {
            builder.field(ADAPTIVE_ALLOCATIONS, (ToXContent)this.adaptiveAllocationsSettings);
        }
        if (this.deploymentId != null) {
            builder.field(DEPLOYMENT_ID, this.deploymentId);
        }
    }

    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_13_0;
    }

    public ElasticsearchInternalServiceSettings updateServiceSettings(Map<String, Object> serviceSettings) {
        ValidationException validationException = new ValidationException();
        HashMap<String, Object> mutableServiceSettings = new HashMap<String, Object>(serviceSettings);
        Integer numAllocations = ServiceUtils.extractOptionalPositiveInteger(mutableServiceSettings, NUM_ALLOCATIONS, "service_settings", validationException);
        AdaptiveAllocationsSettings adaptiveAllocationsSettings = ServiceUtils.removeAsAdaptiveAllocationsSettings(mutableServiceSettings, ADAPTIVE_ALLOCATIONS, validationException);
        if (numAllocations == null && adaptiveAllocationsSettings == null) {
            validationException.addValidationError(ServiceUtils.missingOneOfSettingsErrorMsg(List.of(NUM_ALLOCATIONS, ADAPTIVE_ALLOCATIONS), "service_settings"));
        }
        if (numAllocations != null && adaptiveAllocationsSettings != null) {
            validationException.addValidationError(Strings.format((String)"[%s] cannot be set if [%s] is set", (Object[])new Object[]{NUM_ALLOCATIONS, ADAPTIVE_ALLOCATIONS}));
        }
        validationException.throwIfValidationErrorsExist();
        return this.toBuilder().setNumAllocations(numAllocations).setAdaptiveAllocationsSettings(adaptiveAllocationsSettings).build();
    }

    public Builder toBuilder() {
        return new Builder().setAdaptiveAllocationsSettings(this.adaptiveAllocationsSettings).setDeploymentId(this.deploymentId).setModelId(this.modelId).setNumThreads(this.numThreads).setNumAllocations(this.numAllocations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticsearchInternalServiceSettings that = (ElasticsearchInternalServiceSettings)o;
        return Objects.equals(this.numAllocations, that.numAllocations) && this.numThreads == that.numThreads && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.adaptiveAllocationsSettings, that.adaptiveAllocationsSettings) && Objects.equals(this.deploymentId, that.deploymentId);
    }

    public int hashCode() {
        return Objects.hash(this.numAllocations, this.numThreads, this.modelId, this.adaptiveAllocationsSettings, this.deploymentId);
    }

    public static class Builder {
        private Integer numAllocations;
        private int numThreads;
        private String modelId;
        private AdaptiveAllocationsSettings adaptiveAllocationsSettings;
        private String deploymentId;

        public ElasticsearchInternalServiceSettings build() {
            return new ElasticsearchInternalServiceSettings(this.numAllocations, this.numThreads, this.modelId, this.adaptiveAllocationsSettings, this.deploymentId);
        }

        public Builder setNumAllocations(Integer numAllocations) {
            this.numAllocations = numAllocations;
            return this;
        }

        public Builder setNumThreads(int numThreads) {
            this.numThreads = numThreads;
            return this;
        }

        public Builder setModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public Builder setAdaptiveAllocationsSettings(AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
            this.adaptiveAllocationsSettings = adaptiveAllocationsSettings;
            return this;
        }

        public String getModelId() {
            return this.modelId;
        }

        public Integer getNumAllocations() {
            return this.numAllocations;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public AdaptiveAllocationsSettings getAdaptiveAllocationsSettings() {
            return this.adaptiveAllocationsSettings;
        }
    }
}

