/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class CustomElandInternalTextEmbeddingServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "custom_eland_model_internal_text_embedding_service_settings";
    private final Integer dimensions;
    private final SimilarityMeasure similarityMeasure;
    private final DenseVectorFieldMapper.ElementType elementType;

    public static CustomElandInternalTextEmbeddingServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new MatchException(null, null);
            case ConfigurationParseContext.REQUEST -> CustomElandInternalTextEmbeddingServiceSettings.forRequest(map);
            case ConfigurationParseContext.PERSISTENT -> CustomElandInternalTextEmbeddingServiceSettings.forPersisted(map);
        };
    }

    private static CustomElandInternalTextEmbeddingServiceSettings forRequest(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        CommonFields commonFields = CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map, validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CustomElandInternalTextEmbeddingServiceSettings(commonFields);
    }

    private static CustomElandInternalTextEmbeddingServiceSettings forPersisted(Map<String, Object> map) {
        CommonFields commonFields = CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", new ValidationException());
        return new CustomElandInternalTextEmbeddingServiceSettings(commonFields, dims);
    }

    private static CommonFields commonFieldsFromMap(Map<String, Object> map) {
        return CustomElandInternalTextEmbeddingServiceSettings.commonFieldsFromMap(map, new ValidationException());
    }

    private static CommonFields commonFieldsFromMap(Map<String, Object> map, ValidationException validationException) {
        ElasticsearchInternalServiceSettings.Builder internalSettings = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        DenseVectorFieldMapper.ElementType elementType = ServiceUtils.extractOptionalEnum(map, "element_type", "service_settings", DenseVectorFieldMapper.ElementType::fromString, EnumSet.of(DenseVectorFieldMapper.ElementType.BYTE, DenseVectorFieldMapper.ElementType.FLOAT), validationException);
        return new CommonFields(internalSettings.build(), Objects.requireNonNullElse(similarity, SimilarityMeasure.COSINE), Objects.requireNonNullElse(elementType, DenseVectorFieldMapper.ElementType.FLOAT));
    }

    CustomElandInternalTextEmbeddingServiceSettings(@Nullable Integer numAllocations, int numThreads, String modelId, @Nullable AdaptiveAllocationsSettings adaptiveAllocationsSettings, @Nullable String deploymentId, @Nullable Integer dimensions, SimilarityMeasure similarityMeasure, DenseVectorFieldMapper.ElementType elementType) {
        super(numAllocations, numThreads, modelId, adaptiveAllocationsSettings, deploymentId);
        this.dimensions = dimensions;
        this.similarityMeasure = Objects.requireNonNull(similarityMeasure);
        this.elementType = Objects.requireNonNull(elementType);
    }

    public CustomElandInternalTextEmbeddingServiceSettings(StreamInput in) throws IOException {
        super(in);
        this.dimensions = in.readOptionalVInt();
        this.similarityMeasure = (SimilarityMeasure)in.readEnum(SimilarityMeasure.class);
        this.elementType = (DenseVectorFieldMapper.ElementType)in.readEnum(DenseVectorFieldMapper.ElementType.class);
    }

    private CustomElandInternalTextEmbeddingServiceSettings(CommonFields commonFields) {
        this(commonFields, null);
    }

    private CustomElandInternalTextEmbeddingServiceSettings(CommonFields commonFields, Integer dimensions) {
        super(commonFields.internalServiceSettings.getNumAllocations(), commonFields.internalServiceSettings.getNumThreads(), commonFields.internalServiceSettings.modelId(), commonFields.internalServiceSettings.getAdaptiveAllocationsSettings(), commonFields.internalServiceSettings.getDeploymentId());
        this.dimensions = dimensions;
        this.similarityMeasure = commonFields.similarityMeasure;
        this.elementType = commonFields.elementType;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addInternalSettingsToXContent(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.similarityMeasure != null) {
            builder.field("similarity", (Enum)this.similarityMeasure);
        }
        if (this.elementType != null) {
            builder.field("element_type", (Enum)this.elementType);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.dimensions);
        out.writeEnum((Enum)this.similarityMeasure);
        out.writeEnum((Enum)this.elementType);
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.elementType;
    }

    public SimilarityMeasure similarity() {
        return this.similarityMeasure;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    @Override
    public ToXContentObject getFilteredXContentObject() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomElandInternalTextEmbeddingServiceSettings that = (CustomElandInternalTextEmbeddingServiceSettings)o;
        return super.equals(that) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.similarityMeasure, that.similarityMeasure) && Objects.equals(this.elementType, that.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dimensions, this.similarityMeasure, this.elementType);
    }

    private record CommonFields(ElasticsearchInternalServiceSettings internalServiceSettings, SimilarityMeasure similarityMeasure, DenseVectorFieldMapper.ElementType elementType) {
    }
}

