/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionServiceSettings;

public class ElasticInferenceServiceCompletionModel
extends ElasticInferenceServiceModel {
    private final URI uri = this.createUri();

    public static ElasticInferenceServiceCompletionModel of(ElasticInferenceServiceCompletionModel model, UnifiedCompletionRequest request) {
        ElasticInferenceServiceCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        ElasticInferenceServiceCompletionServiceSettings overriddenServiceSettings = new ElasticInferenceServiceCompletionServiceSettings(Objects.requireNonNullElse(request.model(), originalModelServiceSettings.modelId()));
        return new ElasticInferenceServiceCompletionModel(model, overriddenServiceSettings);
    }

    public ElasticInferenceServiceCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ElasticInferenceServiceComponents elasticInferenceServiceComponents, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, ElasticInferenceServiceCompletionServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents);
    }

    public ElasticInferenceServiceCompletionModel(ElasticInferenceServiceCompletionModel model, ElasticInferenceServiceCompletionServiceSettings serviceSettings) {
        super(model, (ServiceSettings)serviceSettings);
    }

    public ElasticInferenceServiceCompletionModel(String inferenceEntityId, TaskType taskType, String service, ElasticInferenceServiceCompletionServiceSettings serviceSettings, @Nullable TaskSettings taskSettings, @Nullable SecretSettings secretSettings, ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings), new ModelSecrets(secretSettings), serviceSettings, elasticInferenceServiceComponents);
    }

    public ElasticInferenceServiceCompletionServiceSettings getServiceSettings() {
        return (ElasticInferenceServiceCompletionServiceSettings)super.getServiceSettings();
    }

    public URI uri() {
        return this.uri;
    }

    private URI createUri() throws ElasticsearchStatusException {
        try {
            return new URI(this.elasticInferenceServiceComponents().elasticInferenceServiceUrl() + "/api/v1/chat");
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException("Failed to create URI for service [" + this.getConfigurations().getService() + "] with taskType [" + String.valueOf(this.getTaskType()) + "]: " + e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }
}

