/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.ccm;

import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMModel;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMPersistentStorageService;

public class CCMService {
    private final CCMPersistentStorageService ccmPersistentStorageService;

    public CCMService(CCMPersistentStorageService ccmPersistentStorageService) {
        this.ccmPersistentStorageService = Objects.requireNonNull(ccmPersistentStorageService);
    }

    public void isEnabled(ActionListener<Boolean> listener) {
        ActionListener ccmModelListener = ActionListener.wrap(ignored -> listener.onResponse((Object)true), e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onResponse((Object)false);
                return;
            }
            listener.onFailure(e);
        });
        this.ccmPersistentStorageService.get((ActionListener<CCMModel>)ccmModelListener);
    }

    public void storeConfiguration(CCMModel model, ActionListener<Void> listener) {
        this.ccmPersistentStorageService.store(model, listener);
    }

    public void getConfiguration(ActionListener<CCMModel> listener) {
        this.ccmPersistentStorageService.get(listener);
    }

    public void disableCCM(ActionListener<Void> listener) {
        this.ccmPersistentStorageService.delete(listener);
    }
}

