/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.authorization;

import java.util.List;
import java.util.Set;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.InternalPreconfiguredEndpoints;

public class PreconfiguredEndpointModelAdapter {
    public static List<Model> getModels(Set<String> inferenceIds, ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        return inferenceIds.stream().sorted().filter(InternalPreconfiguredEndpoints.EIS_PRECONFIGURED_ENDPOINT_IDS::contains).map(id -> PreconfiguredEndpointModelAdapter.createModel(InternalPreconfiguredEndpoints.getWithInferenceId(id), elasticInferenceServiceComponents)).toList();
    }

    public static Model createModel(InternalPreconfiguredEndpoints.MinimalModel minimalModel, ElasticInferenceServiceComponents elasticInferenceServiceComponents) {
        return new ElasticInferenceServiceModel(minimalModel.configurations(), new ModelSecrets((SecretSettings)EmptySecretSettings.INSTANCE), minimalModel.rateLimitServiceSettings(), elasticInferenceServiceComponents);
    }

    private PreconfiguredEndpointModelAdapter() {
    }
}

