/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RejectableTask;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.TimedListener;

class RequestTask
implements RejectableTask {
    private final RequestManager requestCreator;
    private final InferenceInputs inferenceInputs;
    private final TimedListener<InferenceServiceResults> timedListener;

    RequestTask(RequestManager requestCreator, InferenceInputs inferenceInputs, @Nullable TimeValue timeout, ThreadPool threadPool, ActionListener<InferenceServiceResults> listener) {
        this.requestCreator = Objects.requireNonNull(requestCreator);
        this.timedListener = new TimedListener<InferenceServiceResults>(timeout, listener, threadPool);
        this.inferenceInputs = Objects.requireNonNull(inferenceInputs);
    }

    @Override
    public boolean hasCompleted() {
        return this.timedListener.hasCompleted();
    }

    @Override
    public Supplier<Boolean> getRequestCompletedFunction() {
        return this::hasCompleted;
    }

    @Override
    public InferenceInputs getInferenceInputs() {
        return this.inferenceInputs;
    }

    @Override
    public ActionListener<InferenceServiceResults> getListener() {
        return this.timedListener.getListener();
    }

    @Override
    public void onRejection(Exception e) {
        this.timedListener.getListener().onFailure(e);
    }

    @Override
    public RequestManager getRequestManager() {
        return this.requestCreator;
    }
}

