/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.StoreInferenceEndpointsAction;
import org.elasticsearch.xpack.core.inference.results.ModelStoreResponse;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class TransportStoreEndpointsAction
extends TransportMasterNodeAction<StoreInferenceEndpointsAction.Request, StoreInferenceEndpointsAction.Response> {
    private final ModelRegistry modelRegistry;

    @Inject
    public TransportStoreEndpointsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ModelRegistry modelRegistry) {
        super("cluster:internal/xpack/inference/create_endpoints", transportService, clusterService, threadPool, actionFilters, StoreInferenceEndpointsAction.Request::new, StoreInferenceEndpointsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.modelRegistry = Objects.requireNonNull(modelRegistry);
    }

    protected void masterOperation(Task task, StoreInferenceEndpointsAction.Request request, ClusterState state, ActionListener<StoreInferenceEndpointsAction.Response> masterListener) {
        SubscribableListener.newForked(listener -> this.modelRegistry.storeModels(request.getModels(), (ActionListener<List<ModelStoreResponse>>)listener, request.masterNodeTimeout())).andThenApply(StoreInferenceEndpointsAction.Response::new).addListener(masterListener);
    }

    protected ClusterBlockException checkBlock(StoreInferenceEndpointsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

