/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.CCMEnabledActionResponse;
import org.elasticsearch.xpack.core.inference.action.GetCCMConfigurationAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMService;

public class TransportGetCCMConfigurationAction
extends HandledTransportAction<GetCCMConfigurationAction.Request, CCMEnabledActionResponse> {
    private final CCMService ccmService;
    private final CCMFeature ccmFeature;

    @Inject
    public TransportGetCCMConfigurationAction(TransportService transportService, ActionFilters actionFilters, CCMService ccmService, CCMFeature ccmFeature) {
        super("cluster:monitor/xpack/inference/ccm/get", transportService, actionFilters, GetCCMConfigurationAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.ccmService = Objects.requireNonNull(ccmService);
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    protected void doExecute(Task task, GetCCMConfigurationAction.Request request, ActionListener<CCMEnabledActionResponse> listener) {
        if (!this.ccmFeature.allowConfiguringCcm()) {
            listener.onFailure((Exception)CCMFeature.CCM_FORBIDDEN_EXCEPTION);
            return;
        }
        this.ccmService.isEnabled((ActionListener<Boolean>)listener.delegateFailureAndWrap((delegate, enabled) -> delegate.onResponse((Object)new CCMEnabledActionResponse(enabled.booleanValue()))));
    }
}

