/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.compute.operator.topn.ValueExtractor;
import org.elasticsearch.core.RefCounted;

class ValueExtractorForDoc
implements ValueExtractor {
    private final DocVector vector;
    private final TopNEncoder encoder;

    @Override
    public RefCounted getRefCountedForShard(int position) {
        return this.vector().shardRefCounted(position);
    }

    ValueExtractorForDoc(TopNEncoder encoder, DocVector vector) {
        this.encoder = encoder;
        this.vector = vector;
    }

    DocVector vector() {
        return this.vector;
    }

    @Override
    public void writeValue(BreakingBytesRefBuilder values, int position) {
        this.encoder.encodeInt(this.vector.shards().getInt(position), values);
        this.encoder.encodeInt(this.vector.segments().getInt(position), values);
        this.encoder.encodeInt(this.vector.docs().getInt(position), values);
    }

    public String toString() {
        return "ValueExtractorForDoc";
    }
}

