/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public final class SingletonDoubleBuilder
implements BlockLoader.SingletonDoubleBuilder,
Releasable,
Block.Builder {
    private final double[] values;
    private final BlockFactory blockFactory;
    private int count;

    public SingletonDoubleBuilder(int expectedCount, BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
        blockFactory.adjustBreaker(SingletonDoubleBuilder.valuesSize(expectedCount));
        this.values = new double[expectedCount];
    }

    @Override
    public Block.Builder appendNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder beginPositionEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder endPositionEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long estimatedBytes() {
        return SingletonDoubleBuilder.valuesSize(this.values.length);
    }

    @Override
    public Block build() {
        if (this.values.length != this.count) {
            throw new IllegalStateException("expected " + this.values.length + " values but got " + this.count);
        }
        return this.blockFactory.newDoubleArrayVector(this.values, this.count).asBlock();
    }

    public BlockLoader.SingletonDoubleBuilder appendLongs(BlockDocValuesReader.ToDouble toDouble, long[] longValues, int from, int length) {
        for (int i = 0; i < length; ++i) {
            this.values[this.count + i] = toDouble.convert(longValues[from + i]);
        }
        this.count += length;
        return this;
    }

    public void close() {
        this.blockFactory.adjustBreaker(-SingletonDoubleBuilder.valuesSize(this.values.length));
    }

    static long valuesSize(int count) {
        return (long)count * 8L;
    }
}

