/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.lucene.LuceneMaxFactory;
import org.elasticsearch.compute.lucene.LuceneMinFactory;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

final class LuceneMinMaxOperator
extends LuceneOperator {
    private static final int PAGE_SIZE = 1;
    private boolean seen = false;
    private int remainingDocs;
    private long result;
    private final NumberType numberType;
    private final String fieldName;

    LuceneMinMaxOperator(IndexedByShardId<? extends RefCounted> shardRefCounters, BlockFactory blockFactory, LuceneSliceQueue sliceQueue, String fieldName, NumberType numberType, int limit, long initialResult) {
        super(shardRefCounters, blockFactory, 1, sliceQueue);
        this.remainingDocs = limit;
        this.numberType = numberType;
        this.fieldName = fieldName;
        this.result = initialResult;
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting || this.remainingDocs == 0;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            if ($assertionsDisabled) return null;
            if (this.remainingDocs <= 0) return null;
            throw new AssertionError(this.remainingDocs);
        }
        long start = System.nanoTime();
        try {
            Page page;
            block14: {
                LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
                if (scorer == null) {
                    this.remainingDocs = 0;
                } else {
                    Bits liveDocs;
                    PointValues pointValues;
                    if (!scorer.tags().isEmpty()) {
                        throw new UnsupportedOperationException("tags not supported by " + String.valueOf(this.getClass()));
                    }
                    LeafReader reader = scorer.leafReaderContext().reader();
                    Query query = scorer.weight().getQuery();
                    if ((query == null || query instanceof MatchAllDocsQuery) && (pointValues = reader.getPointValues(this.fieldName)) != null && pointValues.getDocCount() >= this.remainingDocs && (liveDocs = reader.getLiveDocs()) == null) {
                        if (scorer.position() == 0) {
                            this.seen = true;
                            this.result = this.numberType.evaluate(this.result, this.numberType.fromPointValues(pointValues));
                            if (this.remainingDocs != Integer.MAX_VALUE) {
                                this.remainingDocs -= pointValues.getDocCount();
                            }
                        }
                        scorer.markAsDone();
                    }
                    if (!scorer.isDone()) {
                        final LongValues values = this.numberType.multiValueMode(reader.getSortedNumericDocValues(this.fieldName));
                        LeafCollector leafCollector = new LeafCollector(){

                            public void setScorer(Scorable scorer) {
                            }

                            public void collect(int doc) throws IOException {
                                assert (LuceneMinMaxOperator.this.remainingDocs > 0);
                                --LuceneMinMaxOperator.this.remainingDocs;
                                if (values.advanceExact(doc)) {
                                    LuceneMinMaxOperator.this.seen = true;
                                    LuceneMinMaxOperator.this.result = LuceneMinMaxOperator.this.numberType.evaluate(LuceneMinMaxOperator.this.result, values.longValue());
                                }
                            }
                        };
                        scorer.scoreNextRange(leafCollector, reader.getLiveDocs(), this.remainingDocs);
                    }
                }
                page = null;
                if (this.remainingDocs <= 0 && this.pagesEmitted == 0) {
                    Block result = null;
                    BooleanBlock seen = null;
                    try {
                        result = this.seen ? this.numberType.buildResult(this.blockFactory, this.result, 1) : this.numberType.buildEmptyResult(this.blockFactory, 1);
                        seen = this.blockFactory.newConstantBooleanBlockWith(this.seen, 1);
                        page = new Page(1, result, seen);
                        if (page != null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (page != null) throw throwable;
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{result, seen});
                        throw throwable;
                    }
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{result, seen});
                }
            }
            Page page2 = page;
            return page2;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    static sealed interface NumberType
    permits LuceneMinFactory.NumberType, LuceneMaxFactory.NumberType {
        public long fromPointValues(PointValues var1) throws IOException;

        public LongValues multiValueMode(SortedNumericDocValues var1);

        public long evaluate(long var1, long var3);

        public Block buildResult(BlockFactory var1, long var2, int var4);

        public Block buildEmptyResult(BlockFactory var1, int var2);
    }
}

