/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.ExponentialHistogramBlock;
import org.elasticsearch.compute.data.ExponentialHistogramScratch;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.ToMask;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;

public final class ConstantNullBlock
extends AbstractNonThreadSafeRefCounted
implements BooleanBlock,
IntBlock,
LongBlock,
FloatBlock,
DoubleBlock,
BytesRefBlock,
AggregateMetricDoubleBlock,
ExponentialHistogramBlock {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantNullBlock.class);
    private final int positionCount;
    private BlockFactory blockFactory;

    ConstantNullBlock(int positionCount, BlockFactory blockFactory) {
        this.positionCount = positionCount;
        this.blockFactory = blockFactory;
    }

    @Override
    public ConstantNullVector asVector() {
        return null;
    }

    @Override
    public OrdinalBytesRefBlock asOrdinals() {
        return null;
    }

    @Override
    public ToMask toMask() {
        return new ToMask(this.blockFactory.newConstantBooleanVector(false, this.positionCount), false);
    }

    @Override
    public boolean isNull(int position) {
        return true;
    }

    @Override
    public boolean areAllValuesNull() {
        return true;
    }

    @Override
    public boolean mayHaveNulls() {
        return true;
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return false;
    }

    @Override
    public ElementType elementType() {
        return ElementType.NULL;
    }

    @Override
    public ConstantNullBlock filter(int ... positions) {
        return (ConstantNullBlock)this.blockFactory().newConstantNullBlock(positions.length);
    }

    @Override
    public ConstantNullBlock deepCopy(BlockFactory blockFactory) {
        return (ConstantNullBlock)blockFactory.newConstantNullBlock(this.positionCount);
    }

    @Override
    public ConstantNullBlock keepMask(BooleanVector mask) {
        return (ConstantNullBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
    }

    public ReleasableIterator<ConstantNullBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return ReleasableIterator.single((Releasable)((ConstantNullBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getPositionCount());
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public ConstantNullBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Block) {
            Block that = (Block)obj;
            return this.getPositionCount() == 0 && that.getPositionCount() == 0 || this.getPositionCount() == that.getPositionCount() && that.areAllValuesNull();
        }
        if (obj instanceof Vector) {
            Vector that = (Vector)obj;
            return this.getPositionCount() == 0 && that.getPositionCount() == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int pos = 0; pos < this.positionCount; ++pos) {
            result = 31 * result - 1;
        }
        return result;
    }

    @Override
    public DoubleBlock minBlock() {
        return this;
    }

    @Override
    public DoubleBlock maxBlock() {
        return this;
    }

    @Override
    public DoubleBlock sumBlock() {
        return this;
    }

    @Override
    public IntBlock countBlock() {
        return this;
    }

    @Override
    public Block getMetricBlock(int index) {
        return this;
    }

    public String toString() {
        return "ConstantNullBlock[positions=" + this.getPositionCount() + "]";
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsed());
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public float getFloat(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public double getDouble(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public int getInt(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public long getLong(int valueIndex) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public ExponentialHistogram getExponentialHistogram(int valueIndex, ExponentialHistogramScratch scratch) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public Block buildExponentialHistogramComponentBlock(ExponentialHistogramBlock.Component component) {
        this.incRef();
        return this;
    }

    @Override
    public void serializeExponentialHistogram(int valueIndex, ExponentialHistogramBlock.SerializedOutput out, BytesRef scratch) {
        assert (false) : "null block";
        throw new UnsupportedOperationException("null block");
    }

    @Override
    public int getTotalValueCount() {
        return 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getFirstValueIndex(int position) {
        return 0;
    }

    @Override
    public int getValueCount(int position) {
        return 0;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.blockFactory;
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.blockFactory = this.blockFactory.parent();
    }

    static class Builder
    implements Block.Builder {
        final BlockFactory blockFactory;
        private int positionCount;
        private boolean closed = false;

        Builder(BlockFactory blockFactory) {
            this.blockFactory = blockFactory;
        }

        @Override
        public Builder appendNull() {
            ++this.positionCount;
            return this;
        }

        @Override
        public Builder beginPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder endPositionEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Builder copyFrom(Block block, int beginInclusive, int endExclusive) {
            for (int i = beginInclusive; i < endExclusive; ++i) {
                if (block.isNull(i)) continue;
                throw new UnsupportedOperationException("can't append non-null values to a null block");
            }
            this.positionCount += endExclusive - beginInclusive;
            return this;
        }

        @Override
        public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
            return this;
        }

        @Override
        public long estimatedBytes() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public Block build() {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            this.close();
            return this.blockFactory.newConstantNullBlock(this.positionCount);
        }

        public void close() {
            this.closed = true;
        }
    }
}

