/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.PointType;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.WellKnownBinary;

final class SpatialExtentGroupingState
extends AbstractArrayState {
    private final PointType pointType;
    private IntArray minXs;
    private IntArray maxXs;
    private IntArray maxYs;
    private IntArray minYs;

    SpatialExtentGroupingState(PointType pointType) {
        this(pointType, BigArrays.NON_RECYCLING_INSTANCE);
    }

    SpatialExtentGroupingState(PointType pointType, BigArrays bigArrays) {
        super(bigArrays);
        this.pointType = pointType;
        this.minXs = bigArrays.newIntArray(0L, false);
        this.maxXs = bigArrays.newIntArray(0L, false);
        this.maxYs = bigArrays.newIntArray(0L, false);
        this.minYs = bigArrays.newIntArray(0L, false);
        this.enableGroupIdTracking(new SeenGroupIds.Empty());
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset);
        try (IntBlock.Builder minXsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder maxXsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder maxYsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());
             IntBlock.Builder minYsBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    minXsBuilder.appendInt(this.minXs.get((long)group));
                    maxXsBuilder.appendInt(this.maxXs.get((long)group));
                    maxYsBuilder.appendInt(this.maxYs.get((long)group));
                    minYsBuilder.appendInt(this.minYs.get((long)group));
                    continue;
                }
                minXsBuilder.appendInt(Integer.MAX_VALUE);
                maxXsBuilder.appendInt(Integer.MIN_VALUE);
                maxYsBuilder.appendInt(Integer.MIN_VALUE);
                minYsBuilder.appendInt(Integer.MAX_VALUE);
            }
            blocks[offset + 0] = minXsBuilder.build();
            blocks[offset + 1] = maxXsBuilder.build();
            blocks[offset + 2] = maxYsBuilder.build();
            blocks[offset + 3] = minYsBuilder.build();
        }
    }

    public void add(int groupId, int p, IntBlock values) {
        int count = values.getValueCount(p);
        if (count == 6) {
            int i = values.getFirstValueIndex(p);
            int top = values.getInt(i++);
            int bottom = values.getInt(i++);
            int negLeft = values.getInt(i++);
            int negRight = values.getInt(i++);
            int posLeft = values.getInt(i++);
            int posRight = values.getInt(i);
            this.add(groupId, Math.min(negLeft, posLeft), Math.max(negRight, posRight), top, bottom);
        } else if (count == 4) {
            int i = values.getFirstValueIndex(p);
            int minX = values.getInt(i++);
            int maxX = values.getInt(i++);
            int maxY = values.getInt(i++);
            int minY = values.getInt(i);
            this.add(groupId, minX, maxX, maxY, minY);
        } else {
            throw new IllegalArgumentException("Expected 4 or 6 values, got " + count);
        }
    }

    public void add(int groupId, Geometry geometry) {
        this.ensureCapacity(groupId);
        this.pointType.computeEnvelope(geometry).ifPresent(r -> this.add(groupId, this.pointType.encoder().encodeX(r.getMinX()), this.pointType.encoder().encodeX(r.getMaxX()), this.pointType.encoder().encodeY(r.getMaxY()), this.pointType.encoder().encodeY(r.getMinY())));
    }

    public void add(int groupId, long encoded) {
        int x = this.pointType.extractX(encoded);
        int y = this.pointType.extractY(encoded);
        this.add(groupId, x, x, y, y);
    }

    public void add(int groupId, int minX, int maxX, int maxY, int minY) {
        this.ensureCapacity(groupId);
        if (this.hasValue(groupId)) {
            this.minXs.set((long)groupId, Math.min(this.minXs.get((long)groupId), minX));
            this.maxXs.set((long)groupId, Math.max(this.maxXs.get((long)groupId), maxX));
            this.maxYs.set((long)groupId, Math.max(this.maxYs.get((long)groupId), maxY));
            this.minYs.set((long)groupId, Math.min(this.minYs.get((long)groupId), minY));
        } else {
            this.minXs.set((long)groupId, minX);
            this.maxXs.set((long)groupId, maxX);
            this.maxYs.set((long)groupId, maxY);
            this.minYs.set((long)groupId, minY);
        }
        this.trackGroupId(groupId);
    }

    private void ensureCapacity(int groupId) {
        long requiredSize = groupId + 1;
        if (this.minXs.size() < requiredSize) {
            assert (this.minXs.size() == this.maxXs.size() && this.minXs.size() == this.maxYs.size() && this.minXs.size() == this.minYs.size());
            this.minXs = this.bigArrays.grow(this.minXs, requiredSize);
            this.maxXs = this.bigArrays.grow(this.maxXs, requiredSize);
            this.maxYs = this.bigArrays.grow(this.maxYs, requiredSize);
            this.minYs = this.bigArrays.grow(this.minYs, requiredSize);
        }
    }

    public Block toBlock(IntVector selected, DriverContext driverContext) {
        try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                boolean hasInfinity;
                int si = selected.getInt(i);
                if (!this.hasValue(si)) {
                    builder.appendNull();
                    continue;
                }
                int minX = this.minXs.get((long)si);
                int maxX = this.maxXs.get((long)si);
                int maxY = this.maxYs.get((long)si);
                int minY = this.minYs.get((long)si);
                boolean bl = hasInfinity = minX == Integer.MAX_VALUE || maxX == Integer.MIN_VALUE || minY == Integer.MAX_VALUE || maxY == Integer.MIN_VALUE;
                if (hasInfinity) {
                    builder.appendNull();
                    continue;
                }
                BytesRef bytes = new BytesRef(WellKnownBinary.toWKB((Geometry)new Rectangle(this.pointType.encoder().decodeX(minX), this.pointType.encoder().decodeX(maxX), this.pointType.encoder().decodeY(maxY), this.pointType.encoder().decodeY(minY)), (ByteOrder)ByteOrder.LITTLE_ENDIAN));
                builder.appendBytesRef(bytes);
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }
}

