/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.CentroidPointAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointSourceValuesAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialCentroidCartesianPointSourceValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("xVal", ElementType.DOUBLE), new IntermediateStateDesc("xDel", ElementType.DOUBLE), new IntermediateStateDesc("yVal", ElementType.DOUBLE), new IntermediateStateDesc("yDel", ElementType.DOUBLE), new IntermediateStateDesc("count", ElementType.LONG));
    private final DriverContext driverContext;
    private final CentroidPointAggregator.CentroidState state;
    private final List<Integer> channels;

    public SpatialCentroidCartesianPointSourceValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, CentroidPointAggregator.CentroidState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialCentroidCartesianPointSourceValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialCentroidCartesianPointSourceValuesAggregatorFunction(driverContext, channels, SpatialCentroidCartesianPointSourceValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BytesRefBlock wkbBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector wkbVector = wkbBlock.asVector();
        if (wkbVector == null) {
            this.addRawBlock(wkbBlock, mask);
            return;
        }
        this.addRawVector(wkbVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BytesRefBlock wkbBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector wkbVector = wkbBlock.asVector();
        if (wkbVector == null) {
            this.addRawBlock(wkbBlock);
            return;
        }
        this.addRawVector(wkbVector);
    }

    private void addRawVector(BytesRefVector wkbVector) {
        BytesRef wkbScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < wkbVector.getPositionCount(); ++valuesPosition) {
            BytesRef wkbValue = wkbVector.getBytesRef(valuesPosition, wkbScratch);
            SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, wkbValue);
        }
    }

    private void addRawVector(BytesRefVector wkbVector, BooleanVector mask) {
        BytesRef wkbScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < wkbVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            BytesRef wkbValue = wkbVector.getBytesRef(valuesPosition, wkbScratch);
            SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, wkbValue);
        }
    }

    private void addRawBlock(BytesRefBlock wkbBlock) {
        BytesRef wkbScratch = new BytesRef();
        for (int p = 0; p < wkbBlock.getPositionCount(); ++p) {
            int wkbValueCount = wkbBlock.getValueCount(p);
            if (wkbValueCount == 0) continue;
            int wkbStart = wkbBlock.getFirstValueIndex(p);
            int wkbEnd = wkbStart + wkbValueCount;
            for (int wkbOffset = wkbStart; wkbOffset < wkbEnd; ++wkbOffset) {
                BytesRef wkbValue = wkbBlock.getBytesRef(wkbOffset, wkbScratch);
                SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, wkbValue);
            }
        }
    }

    private void addRawBlock(BytesRefBlock wkbBlock, BooleanVector mask) {
        BytesRef wkbScratch = new BytesRef();
        for (int p = 0; p < wkbBlock.getPositionCount(); ++p) {
            int wkbValueCount;
            if (!mask.getBoolean(p) || (wkbValueCount = wkbBlock.getValueCount(p)) == 0) continue;
            int wkbStart = wkbBlock.getFirstValueIndex(p);
            int wkbEnd = wkbStart + wkbValueCount;
            for (int wkbOffset = wkbStart; wkbOffset < wkbEnd; ++wkbOffset) {
                BytesRef wkbValue = wkbBlock.getBytesRef(wkbOffset, wkbScratch);
                SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, wkbValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialCentroidCartesianPointSourceValuesAggregatorFunction.intermediateStateDesc().size());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        assert (xVal.getPositionCount() == 1);
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        assert (xDel.getPositionCount() == 1);
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        assert (yVal.getPositionCount() == 1);
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        assert (yDel.getPositionCount() == 1);
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (count.getPositionCount() == 1);
        SpatialCentroidCartesianPointSourceValuesAggregator.combineIntermediate(this.state, xVal.getDouble(0), xDel.getDouble(0), yVal.getDouble(0), yDel.getDouble(0), count.getLong(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialCentroidCartesianPointSourceValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

