/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopLongLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopLongLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopLongLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopLongLongAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopLongLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopLongLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopLongLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongLongAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopLongLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopLongLongGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_long of longs";
    }
}

