/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.sort.LongIntBucketedSort;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

class TopLongIntAggregator {
    TopLongIntAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays, int limit, boolean ascending) {
        return new SingleState(bigArrays, limit, ascending);
    }

    public static void combine(SingleState state, long v, int outputValue) {
        state.add(v, outputValue);
    }

    public static void combineIntermediate(SingleState state, LongBlock values, IntBlock outputValues) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            TopLongIntAggregator.combine(state, values.getLong(i), outputValues.getInt(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays, int limit, boolean ascending) {
        return new GroupingState(bigArrays, limit, ascending);
    }

    public static void combine(GroupingState state, int groupId, long v, int outputValue) {
        state.add(groupId, v, outputValue);
    }

    public static void combineIntermediate(GroupingState state, int groupId, LongBlock values, IntBlock outputValues, int position) {
        int start = values.getFirstValueIndex(position);
        int end = start + values.getValueCount(position);
        for (int i = start; i < end; ++i) {
            TopLongIntAggregator.combine(state, groupId, values.getLong(i), outputValues.getInt(i));
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        return state.toBlock(ctx.blockFactory(), selected);
    }

    public static class SingleState
    implements AggregatorState {
        private final GroupingState internalState;

        private SingleState(BigArrays bigArrays, int limit, boolean ascending) {
            this.internalState = new GroupingState(bigArrays, limit, ascending);
        }

        public void add(long value, int outputValue) {
            this.internalState.add(0, value, outputValue);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            try (IntVector intValues = driverContext.blockFactory().newConstantIntVector(0, 1);){
                this.internalState.toIntermediate(blocks, offset, intValues, driverContext);
            }
        }

        Block toBlock(BlockFactory blockFactory) {
            try (IntVector intValues = blockFactory.newConstantIntVector(0, 1);){
                Block block = this.internalState.toBlock(blockFactory, intValues);
                return block;
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.internalState);
        }
    }

    public static class GroupingState
    implements GroupingAggregatorState {
        private final LongIntBucketedSort sort;

        private GroupingState(BigArrays bigArrays, int limit, boolean ascending) {
            this.sort = new LongIntBucketedSort(bigArrays, ascending ? SortOrder.ASC : SortOrder.DESC, limit);
        }

        public void add(int groupId, long value, int outputValue) {
            this.sort.collect(value, outputValue, groupId);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            this.sort.toBlocks(driverContext.blockFactory(), blocks, offset, selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            Block[] blocks = new Block[2];
            this.sort.toBlocks(blockFactory, blocks, 0, selected);
            Releasables.close((Releasable)blocks[0]);
            return blocks[1];
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.sort);
        }
    }
}

