/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopIntFloatAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIntFloatGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIntFloatAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopIntFloatAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopIntFloatAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopIntFloatGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopIntFloatAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntFloatAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopIntFloatGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntFloatGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_int of floats";
    }
}

