/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;

class SumDoubleAggregator {
    SumDoubleAggregator() {
    }

    public static SumState initSingle() {
        return new SumState();
    }

    public static void combine(SumState current, double v) {
        current.add(v);
    }

    public static void combine(SumState current, double value, double delta) {
        current.add(value, delta);
    }

    public static void combineIntermediate(SumState state, double inValue, double inDelta, boolean seen) {
        if (seen) {
            SumDoubleAggregator.combine(state, inValue, inDelta);
            state.seen(true);
        }
    }

    public static void evaluateIntermediate(SumState state, DriverContext driverContext, Block[] blocks, int offset) {
        assert (blocks.length >= offset + 3);
        BlockFactory blockFactory = driverContext.blockFactory();
        blocks[offset + 0] = blockFactory.newConstantDoubleBlockWith(state.value(), 1);
        blocks[offset + 1] = blockFactory.newConstantDoubleBlockWith(state.delta(), 1);
        blocks[offset + 2] = blockFactory.newConstantBooleanBlockWith(state.seen(), 1);
    }

    public static Block evaluateFinal(SumState state, DriverContext driverContext) {
        double result = state.value();
        return driverContext.blockFactory().newConstantDoubleBlockWith(result, 1);
    }

    public static GroupingSumState initGrouping(BigArrays bigArrays) {
        return new GroupingSumState(bigArrays);
    }

    public static void combine(GroupingSumState current, int groupId, double v) {
        current.add(v, groupId);
    }

    public static void combineIntermediate(GroupingSumState current, int groupId, double inValue, double inDelta, boolean seen) {
        if (seen) {
            current.add(inValue, inDelta, groupId);
        }
    }

    public static void evaluateIntermediate(GroupingSumState state, Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 3);
        try (DoubleBlock.Builder valuesBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             DoubleBlock.Builder deltaBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
             BooleanBlock.Builder seenBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if ((long)group < state.values.size()) {
                    valuesBuilder.appendDouble(state.values.get((long)group));
                    deltaBuilder.appendDouble(state.deltas.get((long)group));
                } else {
                    valuesBuilder.appendDouble(0.0);
                    deltaBuilder.appendDouble(0.0);
                }
                seenBuilder.appendBoolean(state.hasValue(group));
            }
            blocks[offset + 0] = valuesBuilder.build();
            blocks[offset + 1] = deltaBuilder.build();
            blocks[offset + 2] = seenBuilder.build();
        }
    }

    public static Block evaluateFinal(GroupingSumState state, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        try (DoubleBlock.Builder builder = ctx.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int si = selected.getInt(i);
                if (state.hasValue(si) && (long)si < state.values.size()) {
                    builder.appendDouble(state.values.get((long)si));
                    continue;
                }
                builder.appendNull();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    static class SumState
    extends CompensatedSum
    implements AggregatorState {
        private boolean seen;

        SumState() {
            this(0.0, 0.0);
        }

        SumState(double value, double delta) {
            super(value, delta);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            SumDoubleAggregator.evaluateIntermediate(this, driverContext, blocks, offset);
        }

        public void close() {
        }

        public boolean seen() {
            return this.seen;
        }

        public void seen(boolean seen) {
            this.seen = seen;
        }
    }

    static class GroupingSumState
    extends AbstractArrayState
    implements GroupingAggregatorState {
        static final long BYTES_SIZE = 16L;
        DoubleArray values;
        DoubleArray deltas;

        GroupingSumState(BigArrays bigArrays) {
            super(bigArrays);
            boolean success = false;
            try {
                this.values = bigArrays.newDoubleArray(1L);
                this.deltas = bigArrays.newDoubleArray(1L);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        void add(double valueToAdd, int groupId) {
            this.add(valueToAdd, 0.0, groupId);
        }

        void add(double valueToAdd, double deltaToAdd, int groupId) {
            this.ensureCapacity(groupId);
            if (!Double.isFinite(valueToAdd)) {
                this.values.increment((long)groupId, valueToAdd);
                return;
            }
            double value = this.values.get((long)groupId);
            if (!Double.isFinite(value)) {
                return;
            }
            double delta = this.deltas.get((long)groupId);
            double correctedSum = valueToAdd + (delta + deltaToAdd);
            double updatedValue = value + correctedSum;
            this.deltas.set((long)groupId, correctedSum - (updatedValue - value));
            this.values.set((long)groupId, updatedValue);
            this.trackGroupId(groupId);
        }

        private void ensureCapacity(int groupId) {
            this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
            this.deltas = this.bigArrays.grow(this.deltas, (long)(groupId + 1));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            SumDoubleAggregator.evaluateIntermediate(this, blocks, offset, selected, driverContext);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, this.deltas, () -> super.close()});
        }
    }
}

