/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class RateLongGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.LONG), new IntermediateStateDesc("sampleCounts", ElementType.LONG), new IntermediateStateDesc("resets", ElementType.DOUBLE));
    private ObjectArray<Buffer> buffers;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final BigArrays bigArrays;
    private ObjectArray<ReducedState> reducedStates;
    private final boolean isRateOverTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLongGroupingAggregatorFunction(List<Integer> channels, DriverContext driverContext, boolean isRateOverTime) {
        this.channels = channels;
        this.driverContext = driverContext;
        this.bigArrays = driverContext.bigArrays();
        this.isRateOverTime = isRateOverTime;
        ObjectArray buffers = driverContext.bigArrays().newObjectArray(256L);
        try {
            this.reducedStates = driverContext.bigArrays().newObjectArray(256L);
            this.buffers = buffers;
            buffers = null;
        }
        finally {
            Releasables.close((Releasable)buffers);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock valuesBlock = (LongBlock)page.getBlock(this.channels.get(0));
        if (valuesBlock.areAllValuesNull()) {
            return new GroupingAggregatorFunction.AddInput(this){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                }

                public void close() {
                }
            };
        }
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            assert (false) : "expected timestamp vector in time-series aggregation";
            throw new IllegalStateException("expected timestamp vector in time-series aggregation");
        }
        IntVector sliceIndices = ((IntBlock)page.getBlock(this.channels.get(2))).asVector();
        assert (sliceIndices != null) : "expected slice indices vector in time-series aggregation";
        LongVector futureMaxTimestamps = ((LongBlock)page.getBlock(this.channels.get(3))).asVector();
        assert (futureMaxTimestamps != null) : "expected future max timestamps vector in time-series aggregation";
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                LongVector valuesVector = valuesBlock.asVector();
                if (valuesVector != null) {
                    RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
                } else {
                    RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongBlock valueBlock, LongVector timestampVector) {
        int lastGroup = -1;
        Buffer buffer = null;
        int positionCount = groups.getPositionCount();
        for (int p = 0; p < positionCount; ++p) {
            int valuePosition;
            if (groups.isNull(p) || valueBlock.isNull(valuePosition = p + positionOffset)) continue;
            assert (valueBlock.getValueCount(valuePosition) == 1) : "expected single-valued block " + String.valueOf(valueBlock);
            int groupStart = groups.getFirstValueIndex(p);
            int groupEnd = groupStart + groups.getValueCount(p);
            long timestamp = timestampVector.getLong(valuePosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                long value = valueBlock.getLong(valueBlock.getFirstValueIndex(valuePosition));
                if (lastGroup != groupId) {
                    buffer = this.getBuffer(groupId, 1, timestamp);
                    buffer.appendWithoutResize(timestamp, value);
                    lastGroup = groupId;
                    continue;
                }
                buffer.maybeResizeAndAppend(this.bigArrays, timestamp, value);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock valueBlock, LongVector timestampVector) {
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            this.addSubRange(groupId, positionOffset, positionOffset + positionCount, valueBlock, timestampVector);
        } else {
            int lastGroup = groups.getInt(0);
            int lastPosition = 0;
            for (int p = 1; p < positionCount; ++p) {
                int group = groups.getInt(p);
                if (group == lastGroup) continue;
                this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + p, valueBlock, timestampVector);
                lastGroup = group;
                lastPosition = p;
            }
            this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + positionCount, valueBlock, timestampVector);
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector valueVector, LongVector timestampVector) {
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            this.addSubRange(groupId, positionOffset, positionOffset + positionCount, valueVector, timestampVector);
        } else {
            int lastGroup = groups.getInt(0);
            int lastPosition = 0;
            for (int p = 1; p < positionCount; ++p) {
                int group = groups.getInt(p);
                if (group == lastGroup) continue;
                this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + p, valueVector, timestampVector);
                lastGroup = group;
                lastPosition = p;
            }
            this.addSubRange(lastGroup, positionOffset + lastPosition, positionOffset + positionCount, valueVector, timestampVector);
        }
    }

    private void addSubRange(int group, int from, int to, LongVector valueVector, LongVector timestampVector) {
        Buffer buffer = this.getBuffer(group, to - from, timestampVector.getLong(from));
        buffer.appendRange(from, to, valueVector, timestampVector);
    }

    private void addSubRange(int group, int from, int to, LongBlock valueBlock, LongVector timestampVector) {
        Buffer buffer = this.getBuffer(group, to - from, timestampVector.getLong(from));
        buffer.appendRange(from, to, valueBlock, timestampVector);
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.addIntermediateInputBlock(positionOffset, groups, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.addIntermediateInputBlock(positionOffset, groups, page);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        LongBlock timestamps = (LongBlock)page.getBlock(this.channels.get(0));
        LongBlock values = (LongBlock)page.getBlock(this.channels.get(1));
        assert (timestamps.getTotalValueCount() == values.getTotalValueCount()) : "timestamps=" + String.valueOf(timestamps) + "; values=" + String.valueOf(values);
        if (values.areAllValuesNull()) {
            return;
        }
        LongVector sampleCounts = ((LongBlock)page.getBlock(this.channels.get(2))).asVector();
        DoubleVector resets = ((DoubleBlock)page.getBlock(this.channels.get(3))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuePosition = positionOffset + groupPosition;
            long sampleCount = sampleCounts.getLong(valuePosition);
            if (sampleCount == 0L) continue;
            int groupId = groups.getInt(groupPosition);
            this.reducedStates = this.bigArrays.grow(this.reducedStates, (long)(groupId + 1));
            ReducedState state = (ReducedState)this.reducedStates.get((long)groupId);
            if (state == null) {
                state = new ReducedState();
                this.reducedStates.set((long)groupId, (Object)state);
            }
            state.appendIntervalsFromBlocks(timestamps, values, valuePosition);
            state.samples += sampleCount;
            state.resets += resets.getDouble(valuePosition);
        }
    }

    private void addIntermediateInputBlock(int positionOffset, IntBlock groups, Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        LongBlock timestamps = (LongBlock)page.getBlock(this.channels.get(0));
        LongBlock values = (LongBlock)page.getBlock(this.channels.get(1));
        assert (timestamps.getTotalValueCount() == values.getTotalValueCount()) : "timestamps=" + String.valueOf(timestamps) + "; values=" + String.valueOf(values);
        if (values.areAllValuesNull()) {
            return;
        }
        LongVector sampleCounts = ((LongBlock)page.getBlock(this.channels.get(2))).asVector();
        DoubleVector resets = ((DoubleBlock)page.getBlock(this.channels.get(3))).asVector();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuePosition = positionOffset + groupPosition;
            long sampleCount = sampleCounts.getLong(valuePosition);
            if (sampleCount == 0L || groups.isNull(groupPosition)) continue;
            int firstGroup = groups.getFirstValueIndex(groupPosition);
            int lastGroup = firstGroup + groups.getValueCount(groupPosition);
            for (int g = firstGroup; g < lastGroup; ++g) {
                int groupId = groups.getInt(g);
                this.reducedStates = this.bigArrays.grow(this.reducedStates, (long)(groupId + 1));
                ReducedState state = (ReducedState)this.reducedStates.get((long)groupId);
                if (state == null) {
                    state = new ReducedState();
                    this.reducedStates.set((long)groupId, (Object)state);
                }
                state.appendIntervalsFromBlocks(timestamps, values, valuePosition);
                state.samples += sampleCount;
                state.resets += resets.getDouble(valuePosition);
            }
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int positionCount = selected.getPositionCount();
        try (LongBlock.Builder timestamps = blockFactory.newLongBlockBuilder(positionCount * 2);
             LongBlock.Builder values = blockFactory.newLongBlockBuilder(positionCount * 2);
             LongVector.FixedBuilder sampleCounts = blockFactory.newLongVectorFixedBuilder(positionCount);
             DoubleVector.FixedBuilder resets = blockFactory.newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int group = selected.getInt(p);
                ReducedState state = this.flushAndCombineState(group);
                if (state != null && state.samples > 0L) {
                    timestamps.beginPositionEntry();
                    values.beginPositionEntry();
                    for (Interval interval : state.intervals) {
                        timestamps.appendLong(interval.t1);
                        timestamps.appendLong(interval.t2);
                        values.appendLong(interval.v1);
                        values.appendLong(interval.v2);
                    }
                    timestamps.endPositionEntry();
                    values.endPositionEntry();
                    sampleCounts.appendLong(state.samples);
                    resets.appendDouble(state.resets);
                    continue;
                }
                timestamps.appendLong(0L);
                values.appendLong(0L);
                sampleCounts.appendLong(0L);
                resets.appendDouble(0.0);
            }
            blocks[offset] = timestamps.build();
            blocks[offset + 1] = values.build();
            blocks[offset + 2] = sampleCounts.build().asBlock();
            blocks[offset + 3] = resets.build().asBlock();
        }
    }

    public void close() {
        for (long i = 0L; i < this.buffers.size(); ++i) {
            Buffer buffer = (Buffer)this.buffers.get(i);
            if (buffer == null) continue;
            buffer.close();
        }
        Releasables.close((Releasable[])new Releasable[]{this.reducedStates, this.buffers});
    }

    private Buffer getBuffer(int groupId, int newElements, long firstTimestamp) {
        this.buffers = this.bigArrays.grow(this.buffers, (long)(groupId + 1));
        Buffer buffer = (Buffer)this.buffers.get((long)groupId);
        if (buffer == null) {
            buffer = new Buffer(this.bigArrays, newElements);
            this.buffers.set((long)groupId, (Object)buffer);
        } else {
            buffer.ensureCapacity(this.bigArrays, newElements, firstTimestamp);
        }
        return buffer;
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int positionCount = selected.getPositionCount();
        try (DoubleBlock.Builder rates = blockFactory.newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double rate;
                int group = selected.getInt(p);
                ReducedState state = this.flushAndCombineState(group);
                if (state == null || state.samples < 2L) {
                    rates.appendNull();
                    continue;
                }
                Comparable[] intervals = state.intervals;
                ArrayUtil.timSort((Comparable[])intervals);
                for (int i = 1; i < intervals.length; ++i) {
                    Comparable next = intervals[i - 1];
                    Comparable prev = intervals[i];
                    if (((Interval)prev).v2 <= ((Interval)next).v2) continue;
                    state.resets += (double)((Interval)prev).v2;
                }
                if (evalContext instanceof TimeSeriesGroupingAggregatorEvaluationContext) {
                    TimeSeriesGroupingAggregatorEvaluationContext tsContext = (TimeSeriesGroupingAggregatorEvaluationContext)evalContext;
                    rate = RateLongGroupingAggregatorFunction.extrapolateRate(state, tsContext.rangeStartInMillis(group), tsContext.rangeEndInMillis(group), this.isRateOverTime);
                } else {
                    rate = RateLongGroupingAggregatorFunction.computeRateWithoutExtrapolate(state, this.isRateOverTime);
                }
                rates.appendDouble(rate);
            }
            blocks[offset] = rates.build();
        }
    }

    ReducedState flushAndCombineState(int groupId) {
        Buffer buffer;
        ReducedState state = (long)groupId < this.reducedStates.size() ? (ReducedState)this.reducedStates.getAndSet((long)groupId, null) : null;
        Buffer buffer2 = buffer = (long)groupId < this.buffers.size() ? (Buffer)this.buffers.getAndSet((long)groupId, null) : null;
        if (buffer != null) {
            try (Buffer buffer3 = buffer;){
                if (state == null) {
                    state = new ReducedState();
                }
                buffer.flush(state);
            }
        }
        return state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    private static double computeRateWithoutExtrapolate(ReducedState state, boolean isRateOverTime) {
        assert (state.samples >= 2L) : "rate requires at least two samples; got " + state.samples;
        long firstTS = state.intervals[state.intervals.length - 1].t2;
        long lastTS = state.intervals[0].t1;
        double firstValue = state.intervals[state.intervals.length - 1].v2;
        double lastValue = (double)state.intervals[0].v1 + state.resets;
        if (isRateOverTime) {
            return (lastValue - firstValue) * 1000.0 / (double)(lastTS - firstTS);
        }
        return lastValue - firstValue;
    }

    private static double extrapolateRate(ReducedState state, long rangeStart, long rangeEnd, boolean isRateOverTime) {
        double endGap;
        assert (state.samples >= 2L) : "rate requires at least two samples; got " + state.samples;
        long firstTS = state.intervals[state.intervals.length - 1].t2;
        long lastTS = state.intervals[0].t1;
        double firstValue = state.intervals[state.intervals.length - 1].v2;
        double lastValue = (double)state.intervals[0].v1 + state.resets;
        double sampleTS = lastTS - firstTS;
        double averageSampleInterval = sampleTS / (double)state.samples;
        double slope = (lastValue - firstValue) / sampleTS;
        double startGap = firstTS - rangeStart;
        if (startGap > 0.0) {
            if (startGap > averageSampleInterval * 1.1) {
                startGap = averageSampleInterval / 2.0;
            }
            firstValue = Math.max(0.0, firstValue - startGap * slope);
        }
        if ((endGap = (double)(rangeEnd - lastTS)) > 0.0) {
            if (endGap > averageSampleInterval * 1.1) {
                endGap = averageSampleInterval / 2.0;
            }
            lastValue += endGap * slope;
        }
        if (isRateOverTime) {
            return (lastValue - firstValue) * 1000.0 / (double)(rangeEnd - rangeStart);
        }
        return lastValue - firstValue;
    }

    static final class Buffer
    implements Releasable {
        private LongArray timestamps;
        private LongArray values;
        private int pendingCount;
        int[] sliceOffsets;
        private static final int[] EMPTY_SLICES = new int[0];

        Buffer(BigArrays bigArrays, int initialSize) {
            this.timestamps = bigArrays.newLongArray((long)Math.max(initialSize, 32), false);
            this.values = bigArrays.newLongArray((long)Math.max(initialSize, 32), false);
            this.sliceOffsets = EMPTY_SLICES;
        }

        void appendWithoutResize(long timestamp, long value) {
            this.timestamps.set((long)this.pendingCount, timestamp);
            this.values.set((long)this.pendingCount, value);
            ++this.pendingCount;
        }

        void maybeResizeAndAppend(BigArrays bigArrays, long timestamp, long value) {
            this.timestamps = bigArrays.grow(this.timestamps, (long)(this.pendingCount + 1));
            this.values = bigArrays.grow(this.values, (long)(this.pendingCount + 1));
            this.timestamps.set((long)this.pendingCount, timestamp);
            this.values.set((long)this.pendingCount, value);
            ++this.pendingCount;
        }

        void appendRange(int fromPosition, int toPosition, LongVector valueVector, LongVector timestampVector) {
            for (int p = fromPosition; p < toPosition; ++p) {
                this.values.set((long)this.pendingCount, valueVector.getLong(p));
                this.timestamps.set((long)this.pendingCount, timestampVector.getLong(p));
                ++this.pendingCount;
            }
        }

        void appendRange(int fromPosition, int toPosition, LongBlock valueBlock, LongVector timestampVector) {
            for (int p = fromPosition; p < toPosition; ++p) {
                if (valueBlock.isNull(p)) continue;
                assert (valueBlock.getValueCount(p) == 1) : "expected single-valued block " + String.valueOf(valueBlock);
                this.values.set((long)this.pendingCount, valueBlock.getLong(p));
                this.timestamps.set((long)this.pendingCount, timestampVector.getLong(p));
                ++this.pendingCount;
            }
        }

        void ensureCapacity(BigArrays bigArrays, int count, long firstTimestamp) {
            int newSize = this.pendingCount + count;
            this.timestamps = bigArrays.grow(this.timestamps, (long)newSize);
            this.values = bigArrays.grow(this.values, (long)newSize);
            if (this.pendingCount > 0 && firstTimestamp > this.timestamps.get((long)(this.pendingCount - 1)) && (this.sliceOffsets.length == 0 || this.sliceOffsets[this.sliceOffsets.length - 1] != this.pendingCount)) {
                this.sliceOffsets = ArrayUtil.growExact((int[])this.sliceOffsets, (int)(this.sliceOffsets.length + 1));
                this.sliceOffsets[this.sliceOffsets.length - 1] = this.pendingCount;
            }
        }

        void flush(ReducedState state) {
            if (this.pendingCount == 0) {
                return;
            }
            if (this.pendingCount == 1) {
                ++state.samples;
                long t = this.timestamps.get(0L);
                long v = this.values.get(0L);
                state.appendInterval(new Interval(t, v, t, v));
                return;
            }
            PriorityQueue<Slice> pq = this.mergeQueue();
            Slice top = (Slice)pq.top();
            long lastTimestamp = top.timestamp;
            int position = top.next();
            long lastValue = this.values.get((long)position);
            if (top.exhausted()) {
                pq.pop();
            } else {
                pq.updateTop();
            }
            long prevValue = lastValue;
            int position2 = -1;
            while (pq.size() > 0) {
                Slice top2 = (Slice)pq.top();
                position2 = top2.next();
                if (top2.exhausted()) {
                    pq.pop();
                } else {
                    pq.updateTop();
                }
                long val = this.values.get((long)position2);
                if (val > prevValue) {
                    state.resets += (double)val;
                }
                prevValue = val;
            }
            state.samples += (long)this.pendingCount;
            state.appendInterval(new Interval(lastTimestamp, lastValue, this.timestamps.get((long)position2), prevValue));
        }

        private PriorityQueue<Slice> mergeQueue() {
            PriorityQueue<Slice> pq = new PriorityQueue<Slice>(this, this.sliceOffsets.length + 1){

                protected boolean lessThan(Slice a, Slice b) {
                    return a.timestamp > b.timestamp;
                }
            };
            int startOffset = 0;
            for (int sliceOffset : this.sliceOffsets) {
                pq.add((Object)new Slice(this, startOffset, sliceOffset));
                startOffset = sliceOffset;
            }
            pq.add((Object)new Slice(this, startOffset, this.pendingCount));
            return pq;
        }

        public void close() {
            this.timestamps.close();
            this.values.close();
        }
    }

    static final class ReducedState {
        private static final Interval[] EMPTY_INTERVALS = new Interval[0];
        long samples;
        double resets;
        Interval[] intervals = EMPTY_INTERVALS;

        ReducedState() {
        }

        void appendInterval(Interval interval) {
            int currentSize = this.intervals.length;
            this.intervals = (Interval[])ArrayUtil.growExact((Object[])this.intervals, (int)(currentSize + 1));
            this.intervals[currentSize] = interval;
        }

        void appendIntervalsFromBlocks(LongBlock ts, LongBlock vs, int position) {
            int tsFirst = ts.getFirstValueIndex(position);
            int vsFirst = vs.getFirstValueIndex(position);
            int count = ts.getValueCount(position);
            assert (count % 2 == 0) : "expected even number of values for intervals, got " + count + " in " + String.valueOf(ts);
            int currentSize = this.intervals.length;
            this.intervals = (Interval[])ArrayUtil.growExact((Object[])this.intervals, (int)(currentSize + count / 2));
            for (int i = 0; i < count; i += 2) {
                Interval interval = new Interval(ts.getLong(tsFirst + i), vs.getLong(vsFirst + i), ts.getLong(tsFirst + i + 1), vs.getLong(vsFirst + i + 1));
                this.intervals[currentSize++] = interval;
            }
        }
    }

    record Interval(long t1, long v1, long t2, long v2) implements Comparable<Interval>
    {
        @Override
        public int compareTo(Interval other) {
            return Long.compare(other.t1, this.t1);
        }
    }

    static final class Slice {
        int start;
        long timestamp;
        final int end;
        final Buffer buffer;

        Slice(Buffer buffer, int start, int end) {
            this.buffer = buffer;
            this.start = start;
            this.end = end;
            this.timestamp = buffer.timestamps.get((long)start);
        }

        boolean exhausted() {
            return this.start >= this.end;
        }

        int next() {
            int index = this.start++;
            if (this.start < this.end) {
                this.timestamp = this.buffer.timestamps.get((long)this.start);
            }
            return index;
        }
    }

    public static final class FunctionSupplier
    implements AggregatorFunctionSupplier {
        private final boolean isRateOverTime;

        public FunctionSupplier(boolean isRateOverTime) {
            this.isRateOverTime = isRateOverTime;
        }

        @Override
        public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
            return INTERMEDIATE_STATE_DESC;
        }

        @Override
        public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public RateLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
            return new RateLongGroupingAggregatorFunction(channels, driverContext, this.isRateOverTime);
        }

        @Override
        public String describe() {
            return "rate of long";
        }
    }
}

