/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileIntAggregator;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileIntAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("quart", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final QuantileStates.SingleState state;
    private final List<Integer> channels;
    private final double percentile;

    public PercentileIntAggregatorFunction(DriverContext driverContext, List<Integer> channels, QuantileStates.SingleState state, double percentile) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.percentile = percentile;
    }

    public static PercentileIntAggregatorFunction create(DriverContext driverContext, List<Integer> channels, double percentile) {
        return new PercentileIntAggregatorFunction(driverContext, channels, PercentileIntAggregator.initSingle(driverContext, percentile), percentile);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        IntBlock vBlock = (IntBlock)page.getBlock(this.channels.get(0));
        IntVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        IntBlock vBlock = (IntBlock)page.getBlock(this.channels.get(0));
        IntVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(IntVector vVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            int vValue = vVector.getInt(valuesPosition);
            PercentileIntAggregator.combine(this.state, vValue);
        }
    }

    private void addRawVector(IntVector vVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            int vValue = vVector.getInt(valuesPosition);
            PercentileIntAggregator.combine(this.state, vValue);
        }
    }

    private void addRawBlock(IntBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                int vValue = vBlock.getInt(vOffset);
                PercentileIntAggregator.combine(this.state, vValue);
            }
        }
    }

    private void addRawBlock(IntBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                int vValue = vBlock.getInt(vOffset);
                PercentileIntAggregator.combine(this.state, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + PercentileIntAggregatorFunction.intermediateStateDesc().size());
        Object quartUncast = page.getBlock(this.channels.get(0));
        if (quartUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector quart = ((BytesRefBlock)quartUncast).asVector();
        assert (quart.getPositionCount() == 1);
        BytesRef quartScratch = new BytesRef();
        PercentileIntAggregator.combineIntermediate(this.state, quart.getBytesRef(0, quartScratch));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = PercentileIntAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

