/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class FirstDocIdGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("_doc", ElementType.DOC));
    private final int channel;
    private final DriverContext driverContext;
    private int maxGroupId = -1;
    private final BigArrays bigArrays;
    private IntArray docs;
    private final Map<Integer, RefCounted> contextRefs = new HashMap<Integer, RefCounted>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FirstDocIdGroupingAggregatorFunction(List<Integer> channels, DriverContext driverContext) {
        this.channel = channels.getFirst();
        this.driverContext = driverContext;
        this.bigArrays = driverContext.bigArrays();
        boolean success = false;
        try {
            this.docs = this.bigArrays.newIntArray(1024L, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        DocBlock docBlock = (DocBlock)page.getBlock(this.channel);
        if (docBlock.areAllValuesNull()) {
            return new GroupingAggregatorFunction.AddInput(this){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                }

                public void close() {
                }
            };
        }
        final DocVector docVector = docBlock.asVector();
        if (docVector == null) {
            assert (false) : "expected doc vector for first_doc_id";
            throw new IllegalStateException("expected doc vector for first_doc_id");
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                FirstDocIdGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, docVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, DocVector docVector) {
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            if (groupId > this.maxGroupId) {
                this.collectOneDoc(groupId, docVector, positionOffset);
            }
        } else {
            for (int p = 0; p < positionCount; ++p) {
                int groupId = groups.getInt(p);
                if (groupId <= this.maxGroupId) continue;
                this.collectOneDoc(groupId, docVector, p + positionOffset);
            }
        }
    }

    private void collectOneDoc(int groupId, DocVector docVector, int valuePosition) {
        this.maxGroupId = groupId;
        int shard = docVector.shards().getInt(valuePosition);
        int segment = docVector.segments().getInt(valuePosition);
        int doc = docVector.docs().getInt(valuePosition);
        this.docs = this.bigArrays.grow(this.docs, 3L * (long)groupId + 3L);
        this.docs.set(3L * (long)groupId, shard);
        this.docs.set(3L * (long)groupId + 1L, segment);
        this.docs.set(3L * (long)groupId + 2L, doc);
        if (!this.contextRefs.containsKey(shard)) {
            RefCounted refCounted = docVector.shardRefCounted(shard);
            refCounted.mustIncRef();
            this.contextRefs.put(shard, refCounted);
        }
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        throw new UnsupportedOperationException("first_doc_id does not handle intermediate input");
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        throw new UnsupportedOperationException("first_doc_id does not handle intermediate input");
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        throw new UnsupportedOperationException("first_doc_id does not handle intermediate input");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        BlockFactory blockFactory = this.driverContext.blockFactory();
        int positionCount = selected.getPositionCount();
        try (IntVector.FixedBuilder segmentBuilder = blockFactory.newIntVectorFixedBuilder(positionCount);
             IntVector.FixedBuilder docBuilder = blockFactory.newIntVectorFixedBuilder(positionCount);){
            IntVector shardVector;
            for (int p = 0; p < positionCount; ++p) {
                int group = selected.getInt(p);
                segmentBuilder.appendInt(this.docs.get(3L * (long)group + 1L));
                docBuilder.appendInt(this.docs.get(3L * (long)group + 2L));
            }
            if (this.contextRefs.size() == 1) {
                shardVector = blockFactory.newConstantIntVector((Integer)Iterables.get(this.contextRefs.keySet(), (int)0), positionCount);
            } else {
                try (IntVector.FixedBuilder shardBuilder = blockFactory.newIntVectorFixedBuilder(positionCount);){
                    for (int p = 0; p < positionCount; ++p) {
                        int group = selected.getInt(p);
                        shardBuilder.appendInt(this.docs.get(3L * (long)group));
                    }
                    shardVector = shardBuilder.build();
                }
            }
            IntVector segmentVector = null;
            IntVector docVector = null;
            try {
                segmentVector = segmentBuilder.build();
                docVector = docBuilder.build();
                blocks[offset] = new DocVector(new MappedShardRefs<RefCounted>(this.contextRefs), shardVector, segmentVector, docVector, null).asBlock();
            }
            catch (Throwable throwable) {
                if (blocks[offset] == null) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardVector, segmentVector, docVector});
                }
                throw throwable;
            }
            if (blocks[offset] == null) {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardVector, segmentVector, docVector});
            }
        }
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.docs, () -> {
            for (RefCounted ref : this.contextRefs.values()) {
                ref.decRef();
            }
        }});
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        this.evaluateIntermediate(blocks, offset, selected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channel=").append(this.channel);
        sb.append("]");
        return sb.toString();
    }

    public record MappedShardRefs<T>(Map<Integer, T> refs) implements IndexedByShardId<T>
    {
        @Override
        public T get(int shardId) {
            return this.refs.get(shardId);
        }

        @Override
        public Collection<? extends T> collection() {
            return this.refs.values();
        }

        @Override
        public <S> IndexedByShardId<S> map(Function<T, S> mapper) {
            HashMap<Integer, S> newMap = new HashMap<Integer, S>();
            for (Map.Entry<Integer, T> entry : this.refs.entrySet()) {
                newMap.put(entry.getKey(), mapper.apply(entry.getValue()));
            }
            return new MappedShardRefs(newMap);
        }
    }

    public static final class FunctionSupplier
    implements AggregatorFunctionSupplier {
        @Override
        public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
            return INTERMEDIATE_STATE_DESC;
        }

        @Override
        public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public FirstDocIdGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
            return new FirstDocIdGroupingAggregatorFunction(channels, driverContext);
        }

        @Override
        public String describe() {
            return "first_doc_id";
        }
    }
}

