/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class HistogramParser {
    private static final ParseField COUNTS_FIELD = new ParseField("counts", new String[0]);
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private static final Set<String> ROOT_FIELD_NAMES = Set.of(COUNTS_FIELD.getPreferredName(), VALUES_FIELD.getPreferredName());

    public static boolean isHistogramSubFieldName(String subFieldName) {
        return ROOT_FIELD_NAMES.contains(subFieldName);
    }

    public static ParsedHistogram parse(String mappedFieldName, XContentParser parser) throws IOException {
        ArrayList<Double> values = null;
        ArrayList<Long> counts = null;
        XContentParser.Token token = parser.currentToken();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String fieldName = parser.currentName();
            if (fieldName.equals(VALUES_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                values = new ArrayList<Double>();
                token = parser.nextToken();
                double previousVal = -1.7976931348623157E308;
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    double val = parser.doubleValue();
                    if (val < previousVal) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(VALUES_FIELD) + "] values must be in increasing order, got [" + val + "] but previous value was [" + previousVal + "]");
                    }
                    values.add(val);
                    previousVal = val;
                    token = parser.nextToken();
                }
            } else if (fieldName.equals(COUNTS_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                counts = new ArrayList<Long>();
                token = parser.nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    long count = parser.longValue();
                    if (count < 0L) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], [" + String.valueOf(COUNTS_FIELD) + "] elements must be >= 0 but got " + count);
                    }
                    counts.add(count);
                    token = parser.nextToken();
                }
            } else {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (values == null) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + VALUES_FIELD.getPreferredName() + "]");
        }
        if (counts == null) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + COUNTS_FIELD.getPreferredName() + "]");
        }
        if (values.size() != counts.size()) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected same length from [" + VALUES_FIELD.getPreferredName() + "] and [" + COUNTS_FIELD.getPreferredName() + "] but got [" + values.size() + " != " + counts.size() + "]");
        }
        return new ParsedHistogram((List<Double>)values, (List<Long>)counts);
    }

    public record ParsedHistogram(List<Double> values, List<Long> counts) {
    }
}

