/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.ssl.SslUtil;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public final class X509CertificateSignature
implements Writeable {
    private static final Logger logger = LogManager.getLogger(X509CertificateSignature.class);
    public static final String CROSS_CLUSTER_ACCESS_SIGNATURE_HEADER_KEY = "_cross_cluster_access_signature";
    private final X509Certificate[] certificateChain;
    private final String algorithm;
    private final BytesReference signature;

    public X509CertificateSignature(X509Certificate[] certificateChain, String algorithm, BytesReference signature) {
        this.certificateChain = Objects.requireNonNull(certificateChain);
        this.algorithm = Objects.requireNonNull(algorithm);
        this.signature = Objects.requireNonNull(signature);
    }

    public X509CertificateSignature(StreamInput in) throws IOException {
        this.certificateChain = (X509Certificate[])in.readArray(arrayIn -> {
            byte[] certBytes = arrayIn.readByteArray();
            if (certBytes == null) throw new IOException("Certificate bytes cannot be empty");
            if (certBytes.length == 0) {
                throw new IOException("Certificate bytes cannot be empty");
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);){
                X509Certificate x509;
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                Certificate cert = certFactory.generateCertificate(bais);
                if (!(cert instanceof X509Certificate)) throw new IOException("Input bytes are not an X509 certificate [" + String.valueOf(cert.getClass()) + "] [" + String.valueOf(cert) + "]");
                X509Certificate x509Certificate = x509 = (X509Certificate)cert;
                return x509Certificate;
            }
            catch (CertificateException e) {
                throw new IOException("Cannot read certificate", e);
            }
        }, X509Certificate[]::new);
        this.algorithm = in.readString();
        this.signature = in.readBytesReference();
    }

    public X509Certificate[] certificates() {
        return this.certificateChain;
    }

    public X509Certificate leafCertificate() {
        assert (this.certificateChain.length > 0);
        return this.certificateChain[0];
    }

    public X509Certificate topCertificate() {
        return this.certificateChain[this.certificateChain.length - 1];
    }

    public String algorithm() {
        return this.algorithm;
    }

    public BytesReference signature() {
        return this.signature;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        X509CertificateSignature that = (X509CertificateSignature)obj;
        return Arrays.equals(this.certificateChain, that.certificateChain) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.certificateChain), this.algorithm, this.signature);
    }

    public String toString() {
        return "X509CertificateSignature[certificates=" + Arrays.stream(this.certificateChain).map(X509CertificateSignature::certificateToString).collect(Collectors.joining(",")) + ", algorithm=" + this.algorithm + ", signature=" + String.valueOf(this.signature.toBytesRef()) + "]";
    }

    public static String certificateToString(X509Certificate certificate) {
        return "(" + String.valueOf(certificate.getSubjectX500Principal()) + ";" + certificate.getType() + ";" + X509CertificateSignature.fingerprint(certificate) + ")";
    }

    private static String fingerprint(X509Certificate certificate) {
        try {
            return "SHA1:" + SslUtil.calculateFingerprint((X509Certificate)certificate, (String)"SHA-1");
        }
        catch (CertificateEncodingException e) {
            return "<bad-encoding:" + e.getMessage() + ">";
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((arrayOut, certificate) -> {
            try {
                byte[] encoded = certificate.getEncoded();
                arrayOut.writeByteArray(encoded);
            }
            catch (CertificateEncodingException e) {
                throw new IOException("Cannot convert certificate for " + String.valueOf(certificate.getSubjectX500Principal()) + " to bytes", e);
            }
        }, (Object[])this.certificateChain);
        out.writeString(this.algorithm);
        out.writeBytesReference(this.signature);
    }

    public String encodeToString() throws IOException {
        String encoded = X509CertificateSignature.encode(this);
        logger.trace("Encoding {} as [{}]", new Object[]{this, encoded});
        return encoded;
    }

    public static void writeToContext(ThreadContext ctx, X509CertificateSignature signature) throws IOException {
        ctx.putHeader(CROSS_CLUSTER_ACCESS_SIGNATURE_HEADER_KEY, signature.encodeToString());
    }

    public static X509CertificateSignature readFromContext(ThreadContext ctx) throws IOException {
        String encodedSignature = ctx.getHeader(CROSS_CLUSTER_ACCESS_SIGNATURE_HEADER_KEY);
        return encodedSignature != null ? X509CertificateSignature.decode(encodedSignature) : null;
    }

    public static X509CertificateSignature decode(String encoded) throws IOException {
        logger.trace("Decoding [{}]", new Object[]{encoded});
        try {
            return (X509CertificateSignature)X509CertificateSignature.decode(encoded, X509CertificateSignature::new);
        }
        catch (IOException e) {
            logger.debug("Failed to decode signature", (Throwable)e);
            throw e;
        }
    }

    public static String encode(Writeable writeable) throws IOException {
        return X509CertificateSignature.encode(TransportVersion.current(), (CheckedConsumer<StreamOutput, IOException>)((CheckedConsumer)arg_0 -> ((Writeable)writeable).writeTo(arg_0)));
    }

    public static String encode(TransportVersion transportVersion, CheckedConsumer<StreamOutput, IOException> body) throws IOException {
        try (BytesStreamOutput out = new BytesStreamOutput();){
            out.setTransportVersion(transportVersion);
            TransportVersion.writeVersion((TransportVersion)transportVersion, (StreamOutput)out);
            body.accept((Object)out);
            out.flush();
            String string = Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)out.bytes()));
            return string;
        }
    }

    public static <T> T decode(String encoded, CheckedFunction<StreamInput, T, IOException> body) throws IOException {
        Objects.requireNonNull(encoded);
        byte[] bytes = Base64.getDecoder().decode(encoded);
        StreamInput in = StreamInput.wrap((byte[])bytes);
        TransportVersion transportVersion = TransportVersion.readVersion((StreamInput)in);
        in.setTransportVersion(transportVersion);
        return (T)body.apply((Object)in);
    }
}

