/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.multiproject.action;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.routing.GlobalRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DeleteProjectAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteProjectAction INSTANCE = new DeleteProjectAction();
    public static final String NAME = "cluster:admin/projects/delete";
    private static final Logger logger = LogManager.getLogger(DeleteProjectAction.class);

    public DeleteProjectAction() {
        super(NAME);
    }

    public String name() {
        return NAME;
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final ProjectId projectId;

        public Request(TimeValue masterNodeTimeout, TimeValue ackTimeout, ProjectId projectId) {
            super(masterNodeTimeout, ackTimeout);
            this.projectId = projectId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.projectId = ProjectId.readFrom((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.projectId.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.projectId == null || this.projectId.id() == null || this.projectId.id().isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"project id is missing", validationException);
            }
            return validationException;
        }
    }

    static class DeleteProjectExecutor
    implements ClusterStateTaskExecutor<DeleteProjectTask> {
        DeleteProjectExecutor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<DeleteProjectTask> batchExecutionContext) throws Exception {
            Metadata.Builder metadataBuilder = Metadata.builder((Metadata)batchExecutionContext.initialState().metadata());
            GlobalRoutingTable.Builder routingTableBuilder = GlobalRoutingTable.builder((GlobalRoutingTable)batchExecutionContext.initialState().globalRoutingTable());
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                try {
                    ProjectId projectId = ((DeleteProjectTask)taskContext.getTask()).request().projectId;
                    if (metadataBuilder.getProject(projectId) == null) {
                        taskContext.onFailure((Exception)new IllegalArgumentException("project [" + String.valueOf(projectId) + "] does not exist"));
                        continue;
                    }
                    metadataBuilder.removeProject(projectId);
                    routingTableBuilder.removeProject(projectId);
                    logger.info("Deleted project [" + String.valueOf(projectId) + "] from cluster state version [" + batchExecutionContext.initialState().version() + "]");
                    taskContext.success(() -> ((DeleteProjectTask)taskContext.getTask()).listener.onResponse((Object)AcknowledgedResponse.TRUE));
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            return ClusterState.builder((ClusterState)batchExecutionContext.initialState()).metadata(metadataBuilder.build()).routingTable(routingTableBuilder.build()).build();
        }
    }

    record DeleteProjectTask(Request request, ActionListener<AcknowledgedResponse> listener) implements ClusterStateTaskListener
    {
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    public static class TransportDeleteProjectAction
    extends TransportMasterNodeAction<Request, AcknowledgedResponse> {
        private final MasterServiceTaskQueue<DeleteProjectTask> queue;

        @Inject
        public TransportDeleteProjectAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
            super(INSTANCE.name(), false, transportService, clusterService, threadPool, actionFilters, Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.queue = clusterService.createTaskQueue("delete-project", Priority.NORMAL, (ClusterStateTaskExecutor)new DeleteProjectExecutor());
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
            this.queue.submitTask("delete-project " + String.valueOf(request.projectId), (ClusterStateTaskListener)new DeleteProjectTask(request, listener), request.masterNodeTimeout());
        }
    }
}

