/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregationBuilder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregator;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoLineMultiValuesSource;

final class GeoLineAggregatorFactory
extends MultiValuesSourceAggregatorFactory {
    private final boolean includeSort;
    private final SortOrder sortOrder;
    private final int size;

    GeoLineAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, DocValueFormat format, AggregationContext aggregationContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData, boolean includeSort, SortOrder sortOrder, int size) throws IOException {
        super(name, configs, format, aggregationContext, parent, subFactoriesBuilder, metaData);
        this.includeSort = includeSort;
        this.sortOrder = sortOrder;
        this.size = size;
    }

    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metaData) throws IOException {
        return new GeoLineAggregator.Empty(this.name, this.context, parent, metaData, this.includeSort, this.sortOrder, this.size);
    }

    protected Aggregator doCreateInternal(Map<String, ValuesSourceConfig> configs, DocValueFormat format, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metaData) throws IOException {
        GeoLineMultiValuesSource valuesSources = new GeoLineMultiValuesSource(configs);
        if (this.context.isInSortOrderExecutionRequired()) {
            return new GeoLineAggregator.TimeSeries(this.name, valuesSources, this.context, parent, metaData, this.includeSort, this.sortOrder, this.size);
        }
        return new GeoLineAggregator.Normal(this.name, valuesSources, this.context, parent, metaData, this.includeSort, this.sortOrder, this.size);
    }

    public String getStatsSubtype() {
        return ((ValuesSourceConfig)this.configs.get(GeoLineAggregationBuilder.POINT_FIELD.getPreferredName())).valueSourceType().typeName();
    }
}

