/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.common.geo.GeometryNormalizer;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.H3;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.xpack.spatial.common.H3CartesianGeometry;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;

public final class H3CartesianUtil {
    public static final int MAX_ARRAY_SIZE = 15;
    private static final DoubleUnaryOperator NORMALIZE_LONG_POS;
    private static final DoubleUnaryOperator NORMALIZE_LONG_NEG;
    private static final Map<Long, double[][]> CACHED_H3;
    private static final double[] NORTH_BOUND;
    private static final double[] SOUTH_BOUND;

    public static boolean isPolar(long h3) {
        int res = H3.getResolution((long)h3);
        return H3.southPolarH3((int)res) == h3 || H3.northPolarH3((int)res) == h3;
    }

    public static double getSouthPolarBound(int resolution) {
        return SOUTH_BOUND[resolution];
    }

    public static double getNorthPolarBound(int resolution) {
        return NORTH_BOUND[resolution];
    }

    private static double[][] getCoordinates(long h3) {
        CellBoundary boundary = H3.h3ToGeoBoundary((long)h3);
        int numPoint = H3CartesianUtil.numPoints(h3, boundary);
        double[] xs = new double[numPoint];
        double[] ys = new double[numPoint];
        H3CartesianUtil.computePoints(h3, boundary, xs, ys);
        return new double[][]{xs, ys};
    }

    public static int computePoints(long h3, double[] xs, double[] ys) {
        double[][] cached = CACHED_H3.get(h3);
        if (cached != null) {
            System.arraycopy(cached[0], 0, xs, 0, cached[0].length);
            System.arraycopy(cached[1], 0, ys, 0, cached[0].length);
            return cached[0].length;
        }
        return H3CartesianUtil.computePoints(h3, H3.h3ToGeoBoundary((long)h3), xs, ys);
    }

    private static int numPoints(long h3, CellBoundary cellBoundary) {
        int res = H3.getResolution((long)h3);
        if (h3 != H3.northPolarH3((int)res) && h3 != H3.southPolarH3((int)res)) {
            return cellBoundary.numPoints() + 1;
        }
        return cellBoundary.numPoints() + 5;
    }

    private static int computePoints(long h3, CellBoundary cellBoundary, double[] xs, double[] ys) {
        for (int i = 0; i < cellBoundary.numPoints(); ++i) {
            LatLng latLng = cellBoundary.getLatLon(i);
            xs[i] = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)latLng.getLonDeg()));
            ys[i] = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)latLng.getLatDeg()));
        }
        int numPoints = H3CartesianUtil.numPoints(h3, cellBoundary);
        int res = H3.getResolution((long)h3);
        if (H3.northPolarH3((int)res) == h3) {
            H3CartesianUtil.closePolarComponent(xs, ys, cellBoundary.numPoints(), GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)90.0)));
        } else if (H3.southPolarH3((int)res) == h3) {
            H3CartesianUtil.closePolarComponent(xs, ys, cellBoundary.numPoints(), GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)-90.0)));
            ArrayUtils.reverseSubArray((double[])xs, (int)0, (int)numPoints);
            ArrayUtils.reverseSubArray((double[])ys, (int)0, (int)numPoints);
        } else {
            xs[cellBoundary.numPoints()] = xs[0];
            ys[cellBoundary.numPoints()] = ys[0];
        }
        return numPoints;
    }

    private static void closePolarComponent(double[] xs, double[] ys, int numBoundaryPoints, double pole) {
        H3CartesianUtil.sort(xs, ys, numBoundaryPoints);
        assert (xs[0] > 0.0 != xs[numBoundaryPoints - 1] > 0.0) : "expected first and last element with different sign";
        double y = H3CartesianUtil.datelineIntersectionLatitude(xs[0], ys[0], xs[numBoundaryPoints - 1], ys[numBoundaryPoints - 1]);
        xs[numBoundaryPoints] = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.MAX_LON_ENCODED);
        ys[numBoundaryPoints] = y;
        xs[numBoundaryPoints + 1] = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.MAX_LON_ENCODED);
        ys[numBoundaryPoints + 1] = pole;
        xs[numBoundaryPoints + 2] = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.MIN_LON_ENCODED);
        ys[numBoundaryPoints + 2] = pole;
        xs[numBoundaryPoints + 3] = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.MIN_LON_ENCODED);
        ys[numBoundaryPoints + 3] = y;
        xs[numBoundaryPoints + 4] = xs[0];
        ys[numBoundaryPoints + 4] = ys[0];
    }

    private static void sort(final double[] xs, final double[] ys, int length) {
        new IntroSorter(){
            int pivotPos = -1;

            protected void swap(int i, int j) {
                double tmp = xs[i];
                xs[i] = xs[j];
                xs[j] = tmp;
                tmp = ys[i];
                ys[i] = ys[j];
                ys[j] = tmp;
            }

            protected void setPivot(int i) {
                this.pivotPos = i;
            }

            protected int comparePivot(int j) {
                return Double.compare(xs[this.pivotPos], xs[j]);
            }
        }.sort(0, length);
    }

    private static double datelineIntersectionLatitude(double x1, double y1, double x2, double y2) {
        double t = (180.0 - NORMALIZE_LONG_POS.applyAsDouble(x1)) / (NORMALIZE_LONG_POS.applyAsDouble(x2) - NORMALIZE_LONG_POS.applyAsDouble(x1));
        assert (t > 0.0 && t <= 1.0);
        return y1 + t * (y2 - y1);
    }

    public static LatLonGeometry getLatLonGeometry(long h3) {
        return new H3CartesianGeometry(h3);
    }

    public static Geometry getNormalizeGeometry(long h3) {
        double[] ys;
        double[] xs;
        double[][] cached = CACHED_H3.get(h3);
        if (cached != null) {
            xs = (double[])cached[0].clone();
            ys = (double[])cached[1].clone();
        } else {
            CellBoundary boundary = H3.h3ToGeoBoundary((long)h3);
            int numPoints = H3CartesianUtil.numPoints(h3, boundary);
            xs = new double[numPoints];
            ys = new double[numPoints];
            H3CartesianUtil.computePoints(h3, boundary, xs, ys);
        }
        Polygon polygon = new Polygon(new LinearRing(xs, ys));
        if (H3CartesianUtil.isPolar(h3) || !GeometryNormalizer.needsNormalize((Orientation)Orientation.CCW, (Geometry)polygon)) {
            return polygon;
        }
        Geometry geometry = GeometryNormalizer.apply((Orientation)Orientation.CCW, (Geometry)polygon);
        if (geometry instanceof MultiPolygon) {
            return geometry;
        }
        return GeometryNormalizer.apply((Orientation)Orientation.CW, (Geometry)polygon);
    }

    public static org.elasticsearch.geometry.Rectangle toBoundingBox(long h3) {
        CellBoundary boundary = H3.h3ToGeoBoundary((long)h3);
        double minLat = Double.POSITIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double maxNegLon = Double.NEGATIVE_INFINITY;
        double minPosLon = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boundary.numPoints(); ++i) {
            double lon = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)boundary.getLatLon(i).getLonDeg()));
            double lat = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)boundary.getLatLon(i).getLatDeg()));
            minLat = Math.min(minLat, lat);
            minLon = Math.min(minLon, lon);
            maxLat = Math.max(maxLat, lat);
            maxLon = Math.max(maxLon, lon);
            if (lon < 0.0) {
                maxNegLon = Math.max(maxNegLon, lon);
                continue;
            }
            minPosLon = Math.min(minPosLon, lon);
        }
        int res = H3.getResolution((long)h3);
        if (h3 == H3.northPolarH3((int)res)) {
            return new org.elasticsearch.geometry.Rectangle(-180.0, 180.0, 90.0, minLat);
        }
        if (h3 == H3.southPolarH3((int)res)) {
            return new org.elasticsearch.geometry.Rectangle(-180.0, 180.0, maxLat, -90.0);
        }
        if (maxLon - minLon > 180.0) {
            return new org.elasticsearch.geometry.Rectangle(minPosLon, maxNegLon, maxLat, minLat);
        }
        return new org.elasticsearch.geometry.Rectangle(minLon, maxLon, maxLat, minLat);
    }

    public static GeoRelation relatePoint(double[] xs, double[] ys, int numPoints, boolean crossesDateline, double x, double y) {
        DoubleUnaryOperator normalizeLong = crossesDateline ? NORMALIZE_LONG_POS : DoubleUnaryOperator.identity();
        return H3CartesianUtil.relatePoint(xs, ys, numPoints, x, y, normalizeLong);
    }

    private static GeoRelation relatePoint(double[] xs, double[] ys, int numPoints, double x, double y, DoubleUnaryOperator normalize_lon) {
        boolean res = false;
        x = normalize_lon.applyAsDouble(x);
        for (int i = 0; i < numPoints - 1; ++i) {
            double x1 = normalize_lon.applyAsDouble(xs[i]);
            double x2 = normalize_lon.applyAsDouble(xs[i + 1]);
            double y1 = ys[i];
            double y2 = ys[i + 1];
            if ((y != y1 || y != y2) && (y <= y1 && y >= y2) == (y >= y1 && y <= y2)) continue;
            if (x == x1 && x == x2 || (x <= x1 && x >= x2) != (x >= x1 && x <= x2) && GeoUtils.orient((double)x1, (double)y1, (double)x2, (double)y2, (double)x, (double)y) == 0) {
                return GeoRelation.QUERY_CROSSES;
            }
            if (y1 > y == y2 > y) continue;
            res ^= x < (x2 - x1) * (y - y1) / (y2 - y1) + x1;
        }
        return res ? GeoRelation.QUERY_CONTAINS : GeoRelation.QUERY_DISJOINT;
    }

    public static boolean crossesLine(double[] xs, double[] ys, int numPoints, boolean crossesDateline, double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, boolean includeBoundary) {
        if (crossesDateline) {
            return H3CartesianUtil.crossesLine(xs, ys, numPoints, minX, maxX, minY, maxY, aX, aY, bX, bY, includeBoundary, NORMALIZE_LONG_POS) || H3CartesianUtil.crossesLine(xs, ys, numPoints, minX, maxX, minY, maxY, aX, aY, bX, bY, includeBoundary, NORMALIZE_LONG_NEG);
        }
        return H3CartesianUtil.crossesLine(xs, ys, numPoints, minX, maxX, minY, maxY, aX, aY, bX, bY, includeBoundary, DoubleUnaryOperator.identity());
    }

    private static boolean crossesLine(double[] xs, double[] ys, int numPoints, double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, boolean includeBoundary, DoubleUnaryOperator normalizeLong) {
        for (int i = 0; i < numPoints - 1; ++i) {
            double cy = ys[i];
            double dy = ys[i + 1];
            double cx = normalizeLong.applyAsDouble(xs[i]);
            double dx = normalizeLong.applyAsDouble(xs[i + 1]);
            double lMinX = StrictMath.min(cx, dx);
            double lMaxX = StrictMath.max(cx, dx);
            double lMinY = StrictMath.min(cy, dy);
            double lMaxY = StrictMath.max(cy, dy);
            if (lMaxX < minX || lMinX > maxX || lMinY > maxY || lMaxY < minY || !(includeBoundary ? GeoUtils.lineCrossesLineWithBoundary((double)cx, (double)cy, (double)dx, (double)dy, (double)aX, (double)aY, (double)bX, (double)bY) : GeoUtils.lineCrossesLine((double)cx, (double)cy, (double)dx, (double)dy, (double)aX, (double)aY, (double)bX, (double)bY))) continue;
            return true;
        }
        return false;
    }

    public static boolean crossesTriangle(double[] xs, double[] ys, int numPoints, boolean crossesDateline, double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy, boolean includeBoundary) {
        if (crossesDateline) {
            return H3CartesianUtil.crossesTriangle(xs, ys, numPoints, minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary, NORMALIZE_LONG_POS) || H3CartesianUtil.crossesTriangle(xs, ys, numPoints, minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary, NORMALIZE_LONG_NEG);
        }
        return H3CartesianUtil.crossesTriangle(xs, ys, numPoints, minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, includeBoundary, DoubleUnaryOperator.identity());
    }

    private static boolean crossesTriangle(double[] xs, double[] ys, int numPoints, double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy, boolean includeBoundary, DoubleUnaryOperator normalizeLong) {
        for (int i = 0; i < numPoints - 1; ++i) {
            boolean outside;
            double dy = ys[i];
            double ey = ys[i + 1];
            double dx = normalizeLong.applyAsDouble(xs[i]);
            double ex = normalizeLong.applyAsDouble(xs[i + 1]);
            boolean bl = outside = dy < minY && ey < minY || dy > maxY && ey > maxY || dx < minX && ex < minX || dx > maxX && ex > maxX;
            if (outside || !(includeBoundary ? GeoUtils.lineCrossesLineWithBoundary((double)dx, (double)dy, (double)ex, (double)ey, (double)ax, (double)ay, (double)bx, (double)by) || GeoUtils.lineCrossesLineWithBoundary((double)dx, (double)dy, (double)ex, (double)ey, (double)bx, (double)by, (double)cx, (double)cy) || GeoUtils.lineCrossesLineWithBoundary((double)dx, (double)dy, (double)ex, (double)ey, (double)cx, (double)cy, (double)ax, (double)ay) : GeoUtils.lineCrossesLine((double)dx, (double)dy, (double)ex, (double)ey, (double)ax, (double)ay, (double)bx, (double)by) || GeoUtils.lineCrossesLine((double)dx, (double)dy, (double)ex, (double)ey, (double)bx, (double)by, (double)cx, (double)cy) || GeoUtils.lineCrossesLine((double)dx, (double)dy, (double)ex, (double)ey, (double)cx, (double)cy, (double)ax, (double)ay))) continue;
            return true;
        }
        return false;
    }

    public static boolean crossesBox(double[] xs, double[] ys, int numPoints, boolean crossesDateline, double minX, double maxX, double minY, double maxY, boolean includeBoundary) {
        if (crossesDateline) {
            return H3CartesianUtil.crossesBox(xs, ys, numPoints, minX, maxX, minY, maxY, includeBoundary, NORMALIZE_LONG_POS) || H3CartesianUtil.crossesBox(xs, ys, numPoints, minX, maxX, minY, maxY, includeBoundary, NORMALIZE_LONG_NEG);
        }
        return H3CartesianUtil.crossesBox(xs, ys, numPoints, minX, maxX, minY, maxY, includeBoundary, DoubleUnaryOperator.identity());
    }

    private static boolean crossesBox(double[] xs, double[] ys, int numPoints, double minX, double maxX, double minY, double maxY, boolean includeBoundary, DoubleUnaryOperator normalizeLong) {
        for (int i = 0; i < numPoints - 1; ++i) {
            boolean outside;
            double cy = ys[i];
            double dy = ys[i + 1];
            double cx = normalizeLong.applyAsDouble(xs[i]);
            double dx = normalizeLong.applyAsDouble(xs[i + 1]);
            if (Rectangle.containsPoint((double)cy, (double)cx, (double)minY, (double)maxY, (double)minX, (double)maxX) || Rectangle.containsPoint((double)dy, (double)dx, (double)minY, (double)maxY, (double)minX, (double)maxX)) {
                return true;
            }
            boolean bl = outside = cy < minY && dy < minY || cy > maxY && dy > maxY || cx < minX && dx < minX || cx > maxX && dx > maxX;
            if (outside || !(includeBoundary ? GeoUtils.lineCrossesLineWithBoundary((double)cx, (double)cy, (double)dx, (double)dy, (double)minX, (double)minY, (double)maxX, (double)minY) || GeoUtils.lineCrossesLineWithBoundary((double)cx, (double)cy, (double)dx, (double)dy, (double)maxX, (double)minY, (double)maxX, (double)maxY) || GeoUtils.lineCrossesLineWithBoundary((double)cx, (double)cy, (double)dx, (double)dy, (double)maxX, (double)maxY, (double)minX, (double)maxY) || GeoUtils.lineCrossesLineWithBoundary((double)cx, (double)cy, (double)dx, (double)dy, (double)minX, (double)maxY, (double)minX, (double)minY) : GeoUtils.lineCrossesLine((double)cx, (double)cy, (double)dx, (double)dy, (double)minX, (double)minY, (double)maxX, (double)minY) || GeoUtils.lineCrossesLine((double)cx, (double)cy, (double)dx, (double)dy, (double)maxX, (double)minY, (double)maxX, (double)maxY) || GeoUtils.lineCrossesLine((double)cx, (double)cy, (double)dx, (double)dy, (double)maxX, (double)maxY, (double)minX, (double)maxY) || GeoUtils.lineCrossesLine((double)cx, (double)cy, (double)dx, (double)dy, (double)minX, (double)maxY, (double)minX, (double)minY))) continue;
            return true;
        }
        return false;
    }

    static {
        int res;
        NORMALIZE_LONG_POS = lon -> lon < 0.0 ? lon + 360.0 : lon;
        NORMALIZE_LONG_NEG = lon -> lon > 0.0 ? lon - 360.0 : lon;
        CACHED_H3 = new HashMap<Long, double[][]>();
        for (long res0Cell : H3.getLongRes0Cells()) {
            CACHED_H3.put(res0Cell, H3CartesianUtil.getCoordinates(res0Cell));
            for (long h3 : H3.h3ToChildren((long)res0Cell)) {
                CACHED_H3.put(h3, H3CartesianUtil.getCoordinates(h3));
            }
        }
        for (res = 2; res <= 15; ++res) {
            CACHED_H3.put(H3.northPolarH3((int)res), H3CartesianUtil.getCoordinates(H3.northPolarH3((int)res)));
            CACHED_H3.put(H3.southPolarH3((int)res), H3CartesianUtil.getCoordinates(H3.southPolarH3((int)res)));
        }
        NORTH_BOUND = new double[16];
        SOUTH_BOUND = new double[16];
        for (res = 0; res <= 15; ++res) {
            H3CartesianUtil.NORTH_BOUND[res] = H3CartesianUtil.toBoundingBox(H3.northPolarH3((int)res)).getMinY();
            H3CartesianUtil.SOUTH_BOUND[res] = H3CartesianUtil.toBoundingBox(H3.southPolarH3((int)res)).getMaxY();
        }
    }
}

