/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRulesIndexService;
import org.elasticsearch.xpack.application.rules.action.GetQueryRuleAction;

public class TransportGetQueryRuleAction
extends HandledTransportAction<GetQueryRuleAction.Request, GetQueryRuleAction.Response> {
    protected final QueryRulesIndexService systemIndexService;

    @Inject
    public TransportGetQueryRuleAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/query_rules/rule/get", transportService, actionFilters, GetQueryRuleAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new QueryRulesIndexService(client, clusterService.getClusterSettings());
    }

    protected void doExecute(Task task, GetQueryRuleAction.Request request, ActionListener<GetQueryRuleAction.Response> listener) {
        this.systemIndexService.getQueryRule(request.rulesetId(), request.ruleId(), (ActionListener<QueryRule>)listener.map(GetQueryRuleAction.Response::new));
    }
}

