/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.type.Schema;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.ListRowSet;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;

public class ListCursor
implements Cursor {
    public static final String NAME = "l";
    private final List<List<?>> data;
    private final int columnCount;
    private final int pageSize;

    public ListCursor(List<List<?>> data, int pageSize, int columnCount) {
        this.data = data;
        this.columnCount = columnCount;
        this.pageSize = pageSize;
    }

    public ListCursor(StreamInput in) throws IOException {
        this.data = (List)in.readGenericValue();
        this.columnCount = in.readVInt();
        this.pageSize = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.data);
        out.writeVInt(this.columnCount);
        out.writeVInt(this.pageSize);
    }

    public String getWriteableName() {
        return NAME;
    }

    List<List<?>> data() {
        return this.data;
    }

    int columnCount() {
        return this.columnCount;
    }

    int pageSize() {
        return this.pageSize;
    }

    public static Cursor.Page of(Schema schema, List<List<?>> data, int pageSize) {
        return ListCursor.of(schema, data, pageSize, schema.size());
    }

    private static Cursor.Page of(Schema schema, List<List<?>> data, int pageSize, int columnCount) {
        Cursor next;
        List<List<?>> nextData = data.size() > pageSize ? data.subList(pageSize, data.size()) : Collections.emptyList();
        Cursor cursor = next = nextData.isEmpty() ? Cursor.EMPTY : new ListCursor(nextData, pageSize, columnCount);
        List<List<?>> currData = data.isEmpty() || pageSize == 0 ? Collections.emptyList() : (data.size() == pageSize ? data : data.subList(0, Math.min(pageSize, data.size())));
        return new Cursor.Page(new ListRowSet(schema, currData, columnCount), next);
    }

    @Override
    public void nextPage(SqlConfiguration cfg, Client client, ActionListener<Cursor.Page> listener) {
        listener.onResponse((Object)ListCursor.of(Schema.EMPTY, this.data, this.pageSize, this.columnCount));
    }

    @Override
    public void clear(Client client, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.columnCount, this.pageSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListCursor other = (ListCursor)obj;
        return Objects.equals(this.pageSize, other.pageSize) && Objects.equals(this.columnCount, other.columnCount) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return "cursor for paging list";
    }
}

