/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.sql.querydsl.agg.AggSource;

public abstract class Agg {
    private final String id;
    private final AggSource source;

    Agg(String id, AggSource source) {
        Objects.requireNonNull(source, "AggSource must not be null");
        this.id = id;
        this.source = source;
    }

    public String id() {
        return this.id;
    }

    public AggSource source() {
        return this.source;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Agg other = (Agg)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.source.toString());
    }
}

