/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.XContentBuilder;

public class TokenCountFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "token_count";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final NamedAnalyzer analyzer;
    private final boolean enablePositionIncrements;
    private final Integer nullValue;

    private static TokenCountFieldMapper toType(FieldMapper in) {
        return (TokenCountFieldMapper)in;
    }

    protected TokenCountFieldMapper(String simpleName, MappedFieldType defaultFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, defaultFieldType, builderParams);
        this.analyzer = (NamedAnalyzer)builder.analyzer.getValue();
        this.enablePositionIncrements = (Boolean)builder.enablePositionIncrements.getValue();
        this.nullValue = (Integer)builder.nullValue.getValue();
        this.index = (Boolean)builder.index.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.store = (Boolean)builder.store.getValue();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null && this.nullValue == null) {
            return;
        }
        int tokenCount = value == null ? this.nullValue : TokenCountFieldMapper.countPositions((Analyzer)this.analyzer, this.fullPath(), value, this.enablePositionIncrements);
        NumberFieldMapper.NumberType.INTEGER.addFields(context.doc(), this.fieldType().name(), (Number)tokenCount, IndexType.points((boolean)this.index, (boolean)this.hasDocValues), this.store);
    }

    static int countPositions(Analyzer analyzer, String fieldName, String fieldValue, boolean enablePositionIncrements) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, fieldValue);){
            int count = 0;
            PositionIncrementAttribute position = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                if (enablePositionIncrements) {
                    count += position.getPositionIncrement();
                    continue;
                }
                count += Math.min(1, position.getPositionIncrement());
            }
            tokenStream.end();
            if (enablePositionIncrements) {
                count += position.getPositionIncrement();
            }
            int n = count;
            return n;
        }
    }

    public String analyzer() {
        return this.analyzer.name();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).index, (boolean)true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> TokenCountFieldMapper.toType((FieldMapper)m).store, (boolean)false);
        private final FieldMapper.Parameter<NamedAnalyzer> analyzer = FieldMapper.Parameter.analyzerParam((String)"analyzer", (boolean)true, m -> TokenCountFieldMapper.toType((FieldMapper)m).analyzer, () -> null);
        private final FieldMapper.Parameter<Integer> nullValue = new FieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> o == null ? null : Integer.valueOf(XContentMapValues.nodeIntegerValue((Object)o)), m -> TokenCountFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Boolean> enablePositionIncrements = FieldMapper.Parameter.boolParam((String)"enable_position_increments", (boolean)false, m -> TokenCountFieldMapper.toType((FieldMapper)m).enablePositionIncrements, (boolean)true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.index, this.hasDocValues, this.store, this.analyzer, this.nullValue, this.enablePositionIncrements, this.meta};
        }

        public TokenCountFieldMapper build(MapperBuilderContext context) {
            if (this.analyzer.getValue() == null) {
                throw new MapperParsingException("Analyzer must be set for field [" + this.leafName() + "] but wasn't.");
            }
            TokenCountFieldType ft = new TokenCountFieldType(context.buildFullName(this.leafName()), (Boolean)this.index.getValue(), (Boolean)this.store.getValue(), (Boolean)this.hasDocValues.getValue(), (Number)this.nullValue.getValue(), (Map)this.meta.getValue(), context.isSourceSynthetic());
            return new TokenCountFieldMapper(this.leafName(), (MappedFieldType)ft, this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    static class TokenCountFieldType
    extends NumberFieldMapper.NumberFieldType {
        TokenCountFieldType(String name, boolean isSearchable, boolean isStored, boolean hasDocValues, Number nullValue, Map<String, String> meta, boolean isSyntheticSource) {
            super(name, NumberFieldMapper.NumberType.INTEGER, IndexType.points((boolean)isSearchable, (boolean)hasDocValues), isStored, false, nullValue, meta, null, false, null, null, isSyntheticSource);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (!this.hasDocValues()) {
                return ValueFetcher.EMPTY;
            }
            return new DocValueFetcher(this.docValueFormat(format, null), context.getForField((MappedFieldType)this, MappedFieldType.FielddataOperation.SEARCH));
        }
    }
}

