/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record ReindexDataStreamPersistentTaskState(@Nullable Integer totalIndices, @Nullable Integer totalIndicesToBeUpgraded, @Nullable Long completionTime) implements Task.Status,
PersistentTaskState
{
    public static final String NAME = "reindex-data-stream";
    private static final String TOTAL_INDICES_FIELD = "total_indices_in_data_stream";
    private static final String TOTAL_INDICES_REQUIRING_UPGRADE_FIELD = "total_indices_requiring_upgrade";
    private static final String COMPLETION_TIME_FIELD = "completion_time";
    private static final ConstructingObjectParser<ReindexDataStreamPersistentTaskState, Void> PARSER = new ConstructingObjectParser("reindex-data-stream", true, args -> new ReindexDataStreamPersistentTaskState((Integer)args[0], (Integer)args[1], (Long)args[2]));

    public ReindexDataStreamPersistentTaskState(StreamInput in) throws IOException {
        this(in.readOptionalInt(), in.readOptionalInt(), in.readOptionalLong());
    }

    public boolean isComplete() {
        return this.completionTime != null;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.totalIndices);
        out.writeOptionalInt(this.totalIndicesToBeUpgraded);
        out.writeOptionalLong(this.completionTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.totalIndices != null) {
            builder.field(TOTAL_INDICES_FIELD, this.totalIndices);
        }
        if (this.totalIndicesToBeUpgraded != null) {
            builder.field(TOTAL_INDICES_REQUIRING_UPGRADE_FIELD, this.totalIndicesToBeUpgraded);
        }
        if (this.completionTime != null) {
            builder.field(COMPLETION_TIME_FIELD, this.completionTime);
        }
        builder.endObject();
        return builder;
    }

    public static ReindexDataStreamPersistentTaskState fromXContent(XContentParser parser) {
        return (ReindexDataStreamPersistentTaskState)PARSER.apply(parser, null);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TOTAL_INDICES_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TOTAL_INDICES_REQUIRING_UPGRADE_FIELD, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField(COMPLETION_TIME_FIELD, new String[0]));
    }
}

