/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.script.field.AbstractLongDocValuesField;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongFieldMapper;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongScriptDocValues;

public class UnsignedLongDocValuesField
extends AbstractLongDocValuesField {
    public UnsignedLongDocValuesField(SortedNumericLongValues input, String name) {
        super(input, name);
    }

    public ScriptDocValues<?> newScriptDocValues() {
        return new UnsignedLongScriptDocValues((ScriptDocValues.Supplier<Long>)this);
    }

    protected long formatLong(long raw) {
        return raw ^ Long.MIN_VALUE;
    }

    public List<Long> getValues() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> longValues = new ArrayList<Long>(this.count);
        for (int index = 0; index < this.count; ++index) {
            longValues.add(this.getLong(index));
        }
        return longValues;
    }

    public long getValue(long defaultValue) {
        return this.get(0, defaultValue);
    }

    public long getValue(int index, long defaultValue) {
        return this.get(index, defaultValue);
    }

    protected BigInteger toBigInteger(int index) {
        return BigInteger.valueOf(this.getLong(index)).and(UnsignedLongFieldMapper.BIGINTEGER_2_64_MINUS_ONE);
    }

    public List<BigInteger> asBigIntegers() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BigInteger> bigIntegerValues = new ArrayList<BigInteger>(this.count);
        for (int index = 0; index < this.count; ++index) {
            bigIntegerValues.add(this.toBigInteger(index));
        }
        return bigIntegerValues;
    }

    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.asBigInteger(0, defaultValue);
    }

    public BigInteger asBigInteger(int index, BigInteger defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.toBigInteger(index);
    }
}

