/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openshiftai.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openshiftai.OpenShiftAiUtils;

public class OpenShiftAiRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "openshift_ai_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_N = "top_n";
    private static final OpenShiftAiRerankTaskSettings EMPTY_SETTINGS = new OpenShiftAiRerankTaskSettings(null, null);
    private final Integer topN;
    private final Boolean returnDocuments;

    public static OpenShiftAiRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return OpenShiftAiRerankTaskSettings.of(topN, returnDocuments);
    }

    public static OpenShiftAiRerankTaskSettings of(OpenShiftAiRerankTaskSettings originalSettings, OpenShiftAiRerankTaskSettings requestTaskSettings) {
        if (requestTaskSettings.isEmpty() || originalSettings.equals(requestTaskSettings)) {
            return originalSettings;
        }
        return new OpenShiftAiRerankTaskSettings(requestTaskSettings.getTopN() != null ? requestTaskSettings.getTopN() : originalSettings.getTopN(), requestTaskSettings.getReturnDocuments() != null ? requestTaskSettings.getReturnDocuments() : originalSettings.getReturnDocuments());
    }

    public static OpenShiftAiRerankTaskSettings of(@Nullable Integer topN, @Nullable Boolean returnDocuments) {
        if (topN == null && returnDocuments == null) {
            return EMPTY_SETTINGS;
        }
        return new OpenShiftAiRerankTaskSettings(topN, returnDocuments);
    }

    public OpenShiftAiRerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalInt(), in.readOptionalBoolean());
    }

    public OpenShiftAiRerankTaskSettings(@Nullable Integer topN, @Nullable Boolean doReturnDocuments) {
        this.topN = topN;
        this.returnDocuments = doReturnDocuments;
    }

    public boolean isEmpty() {
        return this.topN == null && this.returnDocuments == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topN != null) {
            builder.field(TOP_N, this.topN);
        }
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return OpenShiftAiUtils.ML_INFERENCE_OPENSHIFT_AI_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return OpenShiftAiUtils.supportsOpenShiftAi(version);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.topN);
        out.writeOptionalBoolean(this.returnDocuments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenShiftAiRerankTaskSettings that = (OpenShiftAiRerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topN, that.topN);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topN);
    }

    public Integer getTopN() {
        return this.topN;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        OpenShiftAiRerankTaskSettings updatedSettings = OpenShiftAiRerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return OpenShiftAiRerankTaskSettings.of(this, updatedSettings);
    }
}

