/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public class OpenAiUnifiedStreamingProcessor
extends DelegatingProcessor<Deque<ServerSentEvent>, StreamingUnifiedChatCompletionResults.Results> {
    public static final String FUNCTION_FIELD = "function";
    private static final Logger logger = LogManager.getLogger(OpenAiUnifiedStreamingProcessor.class);
    private static final String CHOICES_FIELD = "choices";
    private static final String DELTA_FIELD = "delta";
    private static final String CONTENT_FIELD = "content";
    private static final String DONE_MESSAGE = "[done]";
    private static final String REFUSAL_FIELD = "refusal";
    private static final String TOOL_CALLS_FIELD = "tool_calls";
    public static final String ROLE_FIELD = "role";
    public static final String FINISH_REASON_FIELD = "finish_reason";
    public static final String INDEX_FIELD = "index";
    public static final String OBJECT_FIELD = "object";
    public static final String MODEL_FIELD = "model";
    public static final String ID_FIELD = "id";
    public static final String CHOICE_FIELD = "choice";
    public static final String USAGE_FIELD = "usage";
    public static final String TYPE_FIELD = "type";
    public static final String NAME_FIELD = "name";
    public static final String ARGUMENTS_FIELD = "arguments";
    public static final String COMPLETION_TOKENS_FIELD = "completion_tokens";
    public static final String PROMPT_TOKENS_FIELD = "prompt_tokens";
    public static final String TOTAL_TOKENS_FIELD = "total_tokens";
    public static final String PROMPT_TOKENS_DETAILS_FIELD = "prompt_tokens_details";
    public static final String CACHED_TOKENS_FIELD = "cached_tokens";
    private final BiFunction<String, Exception, Exception> errorParser;

    public OpenAiUnifiedStreamingProcessor(BiFunction<String, Exception, Exception> errorParser) {
        this.errorParser = errorParser;
    }

    @Override
    protected void next(Deque<ServerSentEvent> item) throws Exception {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        ArrayDeque results = new ArrayDeque(item.size());
        for (ServerSentEvent event : item) {
            if ("error".equals(event.type()) && event.hasData()) {
                throw this.errorParser.apply(event.data(), null);
            }
            if (!event.hasData()) continue;
            try {
                Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> delta = OpenAiUnifiedStreamingProcessor.parse(parserConfig, event);
                delta.forEach(results::offer);
            }
            catch (Exception e) {
                logger.warn("Failed to parse event from inference provider: {}", (Object)event);
                throw this.errorParser.apply(event.data(), e);
            }
        }
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(new StreamingUnifiedChatCompletionResults.Results(results));
        }
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parse(XContentParserConfiguration parserConfig, ServerSentEvent event) throws IOException {
        if (DONE_MESSAGE.equalsIgnoreCase(event.data())) {
            return Stream.empty();
        }
        return OpenAiUnifiedStreamingProcessor.parse(parserConfig, event.data());
    }

    public static Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> parse(XContentParserConfiguration parserConfig, String data) throws IOException {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, data);){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            StreamingUnifiedChatCompletionResults.ChatCompletionChunk chunk = ChatCompletionChunkParser.parse(jsonParser);
            Stream<StreamingUnifiedChatCompletionResults.ChatCompletionChunk> stream = Stream.of(chunk);
            return stream;
        }
    }

    public static class ChatCompletionChunkParser {
        private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk, Void> PARSER = new ConstructingObjectParser("chat_completion_chunk", true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk((String)args[0], (List)args[1], (String)args[2], (String)args[3], (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage)args[4]));

        public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk parse(XContentParser parser) throws IOException {
            return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.ID_FIELD, new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> ChoiceParser.parse(p), new ParseField(OpenAiUnifiedStreamingProcessor.CHOICES_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.MODEL_FIELD, new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.OBJECT_FIELD, new String[0]));
            PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> UsageParser.parse(p), null, new ParseField(OpenAiUnifiedStreamingProcessor.USAGE_FIELD, new String[0]));
        }

        private static class UsageParser {
            private static final ConstructingObjectParser<Integer, Void> PROMPT_TOKENS_DETAILS_PARSER = new ConstructingObjectParser("prompt_tokens_details", true, args -> (Integer)args[0]);
            private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage, Void> PARSER;

            private UsageParser() {
            }

            public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage parse(XContentParser parser) throws IOException {
                return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage)PARSER.parse(parser, null);
            }

            static {
                PROMPT_TOKENS_DETAILS_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.CACHED_TOKENS_FIELD, new String[0]));
                PARSER = new ConstructingObjectParser(OpenAiUnifiedStreamingProcessor.USAGE_FIELD, true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Usage(((Integer)args[0]).intValue(), ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue(), (Integer)args[3]));
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.COMPLETION_TOKENS_FIELD, new String[0]));
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.PROMPT_TOKENS_FIELD, new String[0]));
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.TOTAL_TOKENS_FIELD, new String[0]));
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), PROMPT_TOKENS_DETAILS_PARSER, new ParseField(OpenAiUnifiedStreamingProcessor.PROMPT_TOKENS_DETAILS_FIELD, new String[0]));
            }
        }

        private static class ChoiceParser {
            private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice, Void> PARSER = new ConstructingObjectParser("choice", true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice((StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta)args[0], (String)args[1], ((Integer)args[2]).intValue()));

            private ChoiceParser() {
            }

            public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice parse(XContentParser parser) {
                return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice)PARSER.apply(parser, null);
            }

            static {
                PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DeltaParser.parse(p), new ParseField(OpenAiUnifiedStreamingProcessor.DELTA_FIELD, new String[0]));
                PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.FINISH_REASON_FIELD, new String[0]));
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.INDEX_FIELD, new String[0]));
            }
        }

        private static class FunctionParser {
            private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function, Void> PARSER = new ConstructingObjectParser("function", true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function((String)args[0], (String)args[1]));

            private FunctionParser() {
            }

            public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function parse(XContentParser parser) throws IOException {
                return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function)PARSER.parse(parser, null);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.ARGUMENTS_FIELD, new String[0]));
                PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.NAME_FIELD, new String[0]));
            }
        }

        private static class ToolCallParser {
            private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall, Void> PARSER = new ConstructingObjectParser("tool_call", true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall(((Integer)args[0]).intValue(), (String)args[1], (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall.Function)args[2], (String)args[3]));

            private ToolCallParser() {
            }

            public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall parse(XContentParser parser) throws IOException {
                return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta.ToolCall)PARSER.parse(parser, null);
            }

            static {
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.INDEX_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.ID_FIELD, new String[0]));
                PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FunctionParser.parse(p), new ParseField(OpenAiUnifiedStreamingProcessor.FUNCTION_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.TYPE_FIELD, new String[0]));
            }
        }

        private static class DeltaParser {
            private static final ConstructingObjectParser<StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta, Void> PARSER = new ConstructingObjectParser("delta", true, args -> new StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta((String)args[0], (String)args[1], (String)args[2], (List)args[3]));

            private DeltaParser() {
            }

            public static StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta parse(XContentParser parser) throws IOException {
                return (StreamingUnifiedChatCompletionResults.ChatCompletionChunk.Choice.Delta)PARSER.parse(parser, null);
            }

            static {
                PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.CONTENT_FIELD, new String[0]));
                PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.REFUSAL_FIELD, new String[0]));
                PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(OpenAiUnifiedStreamingProcessor.ROLE_FIELD, new String[0]));
                PARSER.declareObjectArrayOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ToolCallParser.parse(p), new ParseField(OpenAiUnifiedStreamingProcessor.TOOL_CALLS_FIELD, new String[0]));
            }
        }
    }
}

