/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record ElasticInferenceServiceRerankRequestEntity(String query, List<String> documents, String modelId, @Nullable Integer topNDocumentsOnly) implements ToXContentObject
{
    private static final String QUERY_FIELD = "query";
    private static final String MODEL_FIELD = "model";
    private static final String TOP_N_DOCUMENTS_ONLY_FIELD = "top_n";
    private static final String DOCUMENTS_FIELD = "documents";

    public ElasticInferenceServiceRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
        Objects.requireNonNull(modelId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(QUERY_FIELD, this.query);
        builder.field(MODEL_FIELD, this.modelId);
        if (Objects.nonNull(this.topNDocumentsOnly)) {
            builder.field(TOP_N_DOCUMENTS_ONLY_FIELD, this.topNDocumentsOnly);
        }
        builder.startArray(DOCUMENTS_FIELD);
        for (String document : this.documents) {
            builder.value(document);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

