/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.authorization;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.inference.services.elastic.authorization.AuthorizationPoller;
import org.elasticsearch.xpack.inference.services.elastic.authorization.AuthorizationTaskParams;

public class AuthorizationTaskExecutor
extends PersistentTasksExecutor<AuthorizationTaskParams>
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AuthorizationTaskExecutor.class);
    private final ClusterService clusterService;
    private final PersistentTasksService persistentTasksService;
    private final AuthorizationPoller.Parameters pollerParameters;
    private final AtomicReference<AuthorizationPoller> currentTask = new AtomicReference();

    public static AuthorizationTaskExecutor create(ClusterService clusterService, AuthorizationPoller.Parameters parameters) {
        Objects.requireNonNull(clusterService);
        Objects.requireNonNull(parameters);
        AuthorizationTaskExecutor executor = new AuthorizationTaskExecutor(clusterService, new PersistentTasksService(clusterService, parameters.serviceComponents().threadPool(), parameters.client()), parameters);
        executor.init();
        return executor;
    }

    AuthorizationTaskExecutor(ClusterService clusterService, PersistentTasksService persistentTasksService, AuthorizationPoller.Parameters pollerParameters) {
        super("eis-authorization-poller", (Executor)pollerParameters.serviceComponents().threadPool().executor("inference_utility"));
        this.clusterService = Objects.requireNonNull(clusterService);
        this.persistentTasksService = Objects.requireNonNull(persistentTasksService);
        this.pollerParameters = Objects.requireNonNull(pollerParameters);
    }

    void init() {
        if (!Strings.isNullOrEmpty((String)this.pollerParameters.elasticInferenceServiceSettings().getElasticInferenceServiceUrl())) {
            this.clusterService.addListener((ClusterStateListener)this);
        }
    }

    public AuthorizationPoller getCurrentPollerTask() {
        return this.currentTask.get();
    }

    protected void nodeOperation(AllocatedPersistentTask task, AuthorizationTaskParams params, PersistentTaskState state) {
        AuthorizationPoller authPoller = (AuthorizationPoller)task;
        this.currentTask.set(authPoller);
        authPoller.start();
    }

    public PersistentTasksExecutor.Scope scope() {
        return PersistentTasksExecutor.Scope.CLUSTER;
    }

    protected AuthorizationPoller createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<AuthorizationTaskParams> taskInProgress, Map<String, String> headers) {
        return AuthorizationPoller.create(new AuthorizationPoller.TaskFields(id, type, action, this.getDescription(taskInProgress), parentTaskId, headers), this.pollerParameters);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (AuthorizationTaskExecutor.authorizationTaskExists(event)) {
            return;
        }
        this.persistentTasksService.sendClusterStartRequest("eis-authorization-poller", "eis-authorization-poller", (PersistentTaskParams)new AuthorizationTaskParams(), TimeValue.THIRTY_SECONDS, ActionListener.wrap(persistentTask -> logger.debug("Created authorization poller task"), exception -> {
            Throwable thrownException;
            Throwable throwable = thrownException = exception instanceof RemoteTransportException ? exception.getCause() : exception;
            if (!(thrownException instanceof ResourceAlreadyExistsException)) {
                logger.error("Failed to create authorization poller task", (Throwable)exception);
            }
        }));
    }

    private static boolean authorizationTaskExists(ClusterChangedEvent event) {
        return ClusterPersistentTasksCustomMetadata.getTaskWithId((ClusterState)event.state(), (String)"eis-authorization-poller") != null;
    }

    public static List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return List.of(new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("eis-authorization-poller", new String[0]), AuthorizationTaskParams::fromXContent));
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "eis-authorization-poller", AuthorizationTaskParams::new));
    }
}

