/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.core.inference.chunking.EmbeddingRequestChunker;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProviderCapabilities;
import org.elasticsearch.xpack.inference.services.amazonbedrock.action.AmazonBedrockActionCreator;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockRequestSender;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AmazonBedrockService
extends SenderService {
    public static final String NAME = "amazonbedrock";
    private static final String SERVICE_NAME = "Amazon Bedrock";
    private final Sender amazonBedrockSender;
    private static final EnumSet<TaskType> supportedTaskTypes = EnumSet.of(TaskType.TEXT_EMBEDDING, TaskType.COMPLETION);
    private static final EnumSet<InputType> VALID_INPUT_TYPE_VALUES = EnumSet.of(InputType.INGEST, new InputType[]{InputType.SEARCH, InputType.CLASSIFICATION, InputType.CLUSTERING, InputType.INTERNAL_INGEST, InputType.INTERNAL_SEARCH, InputType.UNSPECIFIED});

    public AmazonBedrockService(HttpRequestSender.Factory httpSenderFactory, AmazonBedrockRequestSender.Factory amazonBedrockFactory, ServiceComponents serviceComponents, InferenceServiceExtension.InferenceServiceFactoryContext context) {
        this(httpSenderFactory, amazonBedrockFactory, serviceComponents, context.clusterService());
    }

    public AmazonBedrockService(HttpRequestSender.Factory httpSenderFactory, AmazonBedrockRequestSender.Factory amazonBedrockFactory, ServiceComponents serviceComponents, ClusterService clusterService) {
        super(httpSenderFactory, serviceComponents, clusterService);
        this.amazonBedrockSender = amazonBedrockFactory.createSender();
    }

    @Override
    protected void doUnifiedCompletionInfer(Model model, UnifiedChatInput inputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ServiceUtils.throwUnsupportedUnifiedCompletionOperation(NAME);
    }

    @Override
    protected void doInfer(Model model, InferenceInputs inputs, Map<String, Object> taskSettings, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        AmazonBedrockActionCreator actionCreator = new AmazonBedrockActionCreator(this.amazonBedrockSender, this.getServiceComponents(), timeout);
        if (model instanceof AmazonBedrockModel) {
            AmazonBedrockModel baseAmazonBedrockModel = (AmazonBedrockModel)model;
            ExecutableAction action = baseAmazonBedrockModel.accept(actionCreator, taskSettings);
            action.execute(inputs, timeout, listener);
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    @Override
    protected void validateInputType(InputType inputType, Model model, ValidationException validationException) {
        if (model instanceof AmazonBedrockModel) {
            ServiceUtils.validateInputTypeAgainstAllowlist(inputType, VALID_INPUT_TYPE_VALUES, SERVICE_NAME, validationException);
        }
    }

    @Override
    protected void doChunkedInfer(Model model, List<ChunkInferenceInput> inputs, Map<String, Object> taskSettings, InputType inputType, TimeValue timeout, ActionListener<List<ChunkedInference>> listener) {
        AmazonBedrockActionCreator actionCreator = new AmazonBedrockActionCreator(this.amazonBedrockSender, this.getServiceComponents(), timeout);
        if (model instanceof AmazonBedrockModel) {
            AmazonBedrockModel baseAmazonBedrockModel = (AmazonBedrockModel)model;
            int maxBatchSize = AmazonBedrockProviderCapabilities.getEmbeddingsMaxBatchSize(baseAmazonBedrockModel.provider());
            List batchedRequests = new EmbeddingRequestChunker(inputs, maxBatchSize, baseAmazonBedrockModel.getConfigurations().getChunkingSettings()).batchRequestsWithListeners(listener);
            for (EmbeddingRequestChunker.BatchRequestAndListener request : batchedRequests) {
                ExecutableAction action = baseAmazonBedrockModel.accept(actionCreator, taskSettings);
                action.execute(new EmbeddingsInput(request.batch().inputs(), inputType), timeout, (ActionListener<InferenceServiceResults>)request.listener());
            }
        } else {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
        }
    }

    public String name() {
        return NAME;
    }

    public void parseRequestConfig(String modelId, TaskType taskType, Map<String, Object> config, ActionListener<Model> parsedModelListener) {
        try {
            Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
            Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
            ChunkingSettings chunkingSettings = null;
            if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
                chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMapOrDefaultEmpty(config, "chunking_settings"));
            }
            AmazonBedrockModel model = AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, serviceSettingsMap, ConfigurationParseContext.REQUEST);
            ServiceUtils.throwIfNotEmptyMap(config, NAME);
            ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, NAME);
            ServiceUtils.throwIfNotEmptyMap(taskSettingsMap, NAME);
            parsedModelListener.onResponse((Object)model);
        }
        catch (Exception e) {
            parsedModelListener.onFailure(e);
        }
    }

    public Model parsePersistedConfigWithSecrets(String modelId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(secrets, "secret_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, secretSettingsMap, ConfigurationParseContext.PERSISTENT);
    }

    public Model parsePersistedConfig(String modelId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> taskSettingsMap = ServiceUtils.removeFromMapOrDefaultEmpty(config, "task_settings");
        ChunkingSettings chunkingSettings = null;
        if (TaskType.TEXT_EMBEDDING.equals((Object)taskType)) {
            chunkingSettings = ChunkingSettingsBuilder.fromMap(ServiceUtils.removeFromMap(config, "chunking_settings"));
        }
        return AmazonBedrockService.createModel(modelId, taskType, serviceSettingsMap, taskSettingsMap, chunkingSettings, null, ConfigurationParseContext.PERSISTENT);
    }

    public InferenceServiceConfiguration getConfiguration() {
        return Configuration.get();
    }

    public EnumSet<TaskType> supportedTaskTypes() {
        return supportedTaskTypes;
    }

    private static AmazonBedrockModel createModel(String inferenceEntityId, TaskType taskType, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, ChunkingSettings chunkingSettings, @Nullable Map<String, Object> secretSettings, ConfigurationParseContext context) {
        switch (taskType) {
            case TEXT_EMBEDDING: {
                AmazonBedrockEmbeddingsModel model = new AmazonBedrockEmbeddingsModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, chunkingSettings, secretSettings, context);
                AmazonBedrockService.checkProviderForTask(TaskType.TEXT_EMBEDDING, model.provider());
                AmazonBedrockService.checkTaskSettingsForTextEmbeddingModel(model);
                return model;
            }
            case COMPLETION: {
                AmazonBedrockChatCompletionModel model = new AmazonBedrockChatCompletionModel(inferenceEntityId, taskType, NAME, serviceSettings, taskSettings, secretSettings, context);
                AmazonBedrockService.checkProviderForTask(TaskType.COMPLETION, model.provider());
                AmazonBedrockService.checkChatCompletionProviderForTopKParameter(model);
                return model;
            }
        }
        throw ServiceUtils.createInvalidTaskTypeException(inferenceEntityId, NAME, taskType, context);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }

    public Set<TaskType> supportedStreamingTasks() {
        return COMPLETION_ONLY;
    }

    public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        if (model instanceof AmazonBedrockEmbeddingsModel) {
            AmazonBedrockEmbeddingsModel embeddingsModel = (AmazonBedrockEmbeddingsModel)model;
            AmazonBedrockEmbeddingsServiceSettings serviceSettings = embeddingsModel.getServiceSettings();
            SimilarityMeasure similarityFromModel = serviceSettings.similarity();
            SimilarityMeasure similarityToUse = similarityFromModel == null ? AmazonBedrockProviderCapabilities.getProviderDefaultSimilarityMeasure(embeddingsModel.provider()) : similarityFromModel;
            AmazonBedrockEmbeddingsServiceSettings updatedServiceSettings = new AmazonBedrockEmbeddingsServiceSettings(serviceSettings.region(), serviceSettings.modelId(), serviceSettings.provider(), embeddingSize, serviceSettings.dimensionsSetByUser(), serviceSettings.maxInputTokens(), similarityToUse, serviceSettings.rateLimitSettings());
            return new AmazonBedrockEmbeddingsModel((Model)embeddingsModel, updatedServiceSettings);
        }
        throw ServiceUtils.invalidModelTypeForUpdateModelWithEmbeddingDetails(model.getClass());
    }

    private static void checkProviderForTask(TaskType taskType, AmazonBedrockProvider provider) {
        if (!AmazonBedrockProviderCapabilities.providerAllowsTaskType(provider, taskType)) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] task type for provider [%s] is not available", (Object[])new Object[]{taskType, provider}), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    private static void checkTaskSettingsForTextEmbeddingModel(AmazonBedrockEmbeddingsModel model) {
        if (model.provider() != AmazonBedrockProvider.COHERE && model.getTaskSettings().cohereTruncation() != null) {
            throw new ElasticsearchStatusException("The [{}] task type for provider [{}] does not allow [truncate] field", RestStatus.BAD_REQUEST, new Object[]{TaskType.TEXT_EMBEDDING, model.provider()});
        }
    }

    private static void checkChatCompletionProviderForTopKParameter(AmazonBedrockChatCompletionModel model) {
        AmazonBedrockChatCompletionTaskSettings taskSettings = model.getTaskSettings();
        if (taskSettings.topK() != null && !AmazonBedrockProviderCapabilities.chatCompletionProviderHasTopKParameter(model.provider())) {
            throw new ElasticsearchStatusException(Strings.format((String)"The [%s] task parameter is not available for provider [%s]", (Object[])new Object[]{"top_k", model.provider()}), RestStatus.BAD_REQUEST, new Object[0]);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.closeWhileHandlingException((Closeable)this.amazonBedrockSender);
    }

    public static class Configuration {
        private static final LazyInitializable<InferenceServiceConfiguration, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("provider", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The model provider for your deployment.").setLabel("Provider").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("model", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The base model ID or an ARN to a custom model based on a foundational model.").setLabel("Model").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("region", new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The region that your model or ARN is deployed in.").setLabel("Region").setRequired(Boolean.valueOf(true)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build());
            configurationMap.put("dimensions", new SettingsConfiguration.Builder(EnumSet.of(TaskType.TEXT_EMBEDDING)).setDescription("The number of dimensions the resulting embeddings should have. For more information refer to https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters-titan-embed-text.html.").setLabel("Dimensions").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.INTEGER).build());
            configurationMap.putAll(AwsSecretSettings.Configuration.get());
            configurationMap.putAll(RateLimitSettings.toSettingsConfigurationWithDescription("By default, the amazonbedrock service sets the number of requests allowed per minute to 240.", supportedTaskTypes));
            return new InferenceServiceConfiguration.Builder().setService(AmazonBedrockService.NAME).setName(AmazonBedrockService.SERVICE_NAME).setTaskTypes(supportedTaskTypes).setConfigurations(configurationMap).build();
        });

        public static InferenceServiceConfiguration get() {
            return (InferenceServiceConfiguration)configuration.getOrCompute();
        }
    }
}

