/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.util.List;
import java.util.Map;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;

public final class AmazonBedrockProviderCapabilities {
    private static final List<AmazonBedrockProvider> embeddingProviders = List.of(AmazonBedrockProvider.AMAZONTITAN, AmazonBedrockProvider.COHERE);
    private static final List<AmazonBedrockProvider> chatCompletionProviders = List.of(AmazonBedrockProvider.AMAZONTITAN, AmazonBedrockProvider.ANTHROPIC, AmazonBedrockProvider.AI21LABS, AmazonBedrockProvider.COHERE, AmazonBedrockProvider.META, AmazonBedrockProvider.MISTRAL);
    private static final List<AmazonBedrockProvider> chatCompletionProvidersWithTopK = List.of(AmazonBedrockProvider.ANTHROPIC, AmazonBedrockProvider.COHERE, AmazonBedrockProvider.MISTRAL);
    private static final Map<AmazonBedrockProvider, SimilarityMeasure> embeddingsDefaultSimilarityMeasure = Map.of(AmazonBedrockProvider.AMAZONTITAN, SimilarityMeasure.COSINE, AmazonBedrockProvider.COHERE, SimilarityMeasure.DOT_PRODUCT);
    private static final Map<AmazonBedrockProvider, Integer> embeddingsDefaultChunkSize = Map.of(AmazonBedrockProvider.AMAZONTITAN, 8192, AmazonBedrockProvider.COHERE, 2048);
    private static final Map<AmazonBedrockProvider, Integer> embeddingsMaxBatchSize = Map.of(AmazonBedrockProvider.AMAZONTITAN, 1, AmazonBedrockProvider.COHERE, 96);

    public static boolean providerAllowsTaskType(AmazonBedrockProvider provider, TaskType taskType) {
        switch (taskType) {
            case COMPLETION: {
                return chatCompletionProviders.contains((Object)provider);
            }
            case TEXT_EMBEDDING: {
                return embeddingProviders.contains((Object)provider);
            }
        }
        return false;
    }

    public static boolean chatCompletionProviderHasTopKParameter(AmazonBedrockProvider provider) {
        return chatCompletionProvidersWithTopK.contains((Object)provider);
    }

    public static SimilarityMeasure getProviderDefaultSimilarityMeasure(AmazonBedrockProvider provider) {
        if (embeddingsDefaultSimilarityMeasure.containsKey((Object)provider)) {
            return embeddingsDefaultSimilarityMeasure.get((Object)provider);
        }
        return SimilarityMeasure.COSINE;
    }

    public static int getEmbeddingsProviderDefaultChunkSize(AmazonBedrockProvider provider) {
        if (embeddingsDefaultChunkSize.containsKey((Object)provider)) {
            return embeddingsDefaultChunkSize.get((Object)provider);
        }
        return 2048;
    }

    public static int getEmbeddingsMaxBatchSize(AmazonBedrockProvider provider) {
        if (embeddingsMaxBatchSize.containsKey((Object)provider)) {
            return embeddingsMaxBatchSize.get((Object)provider);
        }
        return 1;
    }
}

