/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.GetCCMConfigurationAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetCCMConfigurationAction
extends BaseRestHandler {
    private final CCMFeature ccmFeature;

    public RestGetCCMConfigurationAction(CCMFeature ccmFeature) {
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    public String getName() {
        return "get_inference_ccm_configuration_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "_inference/_ccm"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        if (!this.ccmFeature.allowConfiguringCcm()) {
            throw CCMFeature.CCM_FORBIDDEN_EXCEPTION;
        }
        return channel -> client.execute((ActionType)GetCCMConfigurationAction.INSTANCE, (ActionRequest)new GetCCMConfigurationAction.Request(), (ActionListener)new RestToXContentListener(channel));
    }
}

