/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.DeleteCCMConfigurationAction;
import org.elasticsearch.xpack.inference.services.elastic.ccm.CCMFeature;

@ServerlessScope(value=Scope.INTERNAL)
public class RestDeleteCCMConfigurationAction
extends BaseRestHandler {
    private final CCMFeature ccmFeature;

    public RestDeleteCCMConfigurationAction(CCMFeature ccmFeature) {
        this.ccmFeature = Objects.requireNonNull(ccmFeature);
    }

    public String getName() {
        return "delete_inference_ccm_configuration_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "_inference/_ccm"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        if (!this.ccmFeature.allowConfiguringCcm()) {
            throw CCMFeature.CCM_FORBIDDEN_EXCEPTION;
        }
        return channel -> client.execute((ActionType)DeleteCCMConfigurationAction.INSTANCE, (ActionRequest)new DeleteCCMConfigurationAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), RestUtils.getAckTimeout((RestRequest)restRequest)), (ActionListener)new RestToXContentListener(channel));
    }
}

