/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.mapper.OffsetSourceField;

public class OffsetSourceFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "offset_source";
    private static final String SOURCE_NAME_FIELD = "field";
    private static final String START_OFFSET_FIELD = "start";
    private static final String END_OFFSET_FIELD = "end";
    private static final ConstructingObjectParser<OffsetSource, Void> OFFSET_SOURCE_PARSER = new ConstructingObjectParser("offset_source", true, args -> new OffsetSource((String)args[0], (Integer)args[1], (Integer)args[2]));
    public static final FieldMapper.TypeParser PARSER;

    protected OffsetSourceFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams params) {
        super(simpleName, mappedFieldType, params);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (context.doc().getByKey((Object)this.fullPath()) != null) {
            throw new IllegalArgumentException("[offset_source] fields do not support indexing multiple values for the same field [" + this.fullPath() + "] in the same document");
        }
        boolean isWithinLeafObject = context.path().isWithinLeafObject();
        context.path().setWithinLeafObject(true);
        try {
            OffsetSource offsetSource = (OffsetSource)OFFSET_SOURCE_PARSER.parse(parser, null);
            context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)new OffsetSourceField(this.fullPath(), offsetSource.field, offsetSource.start, offsetSource.end));
            context.addToFieldNames(this.fieldType().name());
        }
        finally {
            context.path().setWithinLeafObject(isWithinLeafObject);
        }
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName()).init(this);
    }

    static {
        OFFSET_SOURCE_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(SOURCE_NAME_FIELD, new String[0]));
        OFFSET_SOURCE_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(START_OFFSET_FIELD, new String[0]));
        OFFSET_SOURCE_PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(END_OFFSET_FIELD, new String[0]));
        PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n));
    }

    public record OffsetSource(String field, int start, int end) implements ToXContentObject
    {
        public OffsetSource {
            if (start < 0 || end < 0) {
                throw new IllegalArgumentException("Illegal offsets, expected positive numbers, got: " + start + ":" + end);
            }
            if (start > end) {
                throw new IllegalArgumentException("Illegal offsets, expected start < end, got: " + start + " > " + end);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(OffsetSourceFieldMapper.SOURCE_NAME_FIELD, this.field);
            builder.field(OffsetSourceFieldMapper.START_OFFSET_FIELD, this.start);
            builder.field(OffsetSourceFieldMapper.END_OFFSET_FIELD, this.end);
            return builder.endObject();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<CharsetFormat> charset = FieldMapper.Parameter.enumParam((String)"charset", (boolean)false, i -> CharsetFormat.UTF_16, (Enum)CharsetFormat.UTF_16, CharsetFormat.class);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.charset};
        }

        public OffsetSourceFieldMapper build(MapperBuilderContext context) {
            return new OffsetSourceFieldMapper(this.leafName(), new OffsetSourceFieldType(context.buildFullName(this.leafName()), (CharsetFormat)((Object)this.charset.get()), (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context));
        }
    }

    public static final class OffsetSourceFieldType
    extends MappedFieldType {
        private final CharsetFormat charset;

        public OffsetSourceFieldType(String name, CharsetFormat charset, Map<String, String> meta) {
            super(name, IndexType.terms((boolean)true, (boolean)false), false, meta);
            this.charset = charset;
        }

        public Charset getCharset() {
            return this.charset.charSet;
        }

        public String typeName() {
            return OffsetSourceFieldMapper.CONTENT_TYPE;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("[offset_source] fields do not support sorting, scripting or aggregating");
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new ValueFetcher(){
                OffsetSourceField.OffsetSourceLoader offsetLoader;

                public void setNextReader(LeafReaderContext context) {
                    try {
                        Terms terms = context.reader().terms(this.name());
                        this.offsetLoader = terms != null ? OffsetSourceField.loader(terms) : null;
                    }
                    catch (IOException exc) {
                        throw new UncheckedIOException(exc);
                    }
                }

                public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                    OffsetSource offsetSource = this.offsetLoader != null ? this.offsetLoader.advanceTo(doc) : null;
                    return offsetSource != null ? List.of(offsetSource) : null;
                }

                public StoredFieldsSpec storedFieldsSpec() {
                    return StoredFieldsSpec.NO_REQUIREMENTS;
                }
            };
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Queries on [offset_source] fields are not supported");
        }

        public boolean isSearchable() {
            return false;
        }
    }

    public static enum CharsetFormat {
        UTF_16(StandardCharsets.UTF_16);

        private Charset charSet;

        private CharsetFormat(Charset charSet) {
            this.charSet = charSet;
        }
    }
}

