/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class RequestExecutorServiceSettings {
    static final Setting<Integer> TASK_QUEUE_CAPACITY_SETTING = Setting.intSetting((String)"xpack.inference.http.request_executor.queue_capacity", (int)2000, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_TASK_POLL_FREQUENCY_TIME = TimeValue.timeValueMillis((long)50L);
    static final Setting<TimeValue> TASK_POLL_FREQUENCY_SETTING = Setting.timeSetting((String)"xpack.inference.http.request_executor.task_poll_frequency", (TimeValue)DEFAULT_TASK_POLL_FREQUENCY_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_RATE_LIMIT_GROUP_CLEANUP_INTERVAL = TimeValue.timeValueDays((long)1L);
    static final Setting<TimeValue> RATE_LIMIT_GROUP_CLEANUP_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.inference.http.request_executor.rate_limit_group_cleanup_interval", (TimeValue)DEFAULT_RATE_LIMIT_GROUP_CLEANUP_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_RATE_LIMIT_GROUP_STALE_DURATION = TimeValue.timeValueDays((long)10L);
    static final Setting<TimeValue> RATE_LIMIT_GROUP_STALE_DURATION_SETTING = Setting.timeSetting((String)"xpack.inference.http.request_executor.rate_limit_group_stale_duration", (TimeValue)DEFAULT_RATE_LIMIT_GROUP_STALE_DURATION, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile int queueCapacity;
    private volatile TimeValue taskPollFrequency;
    private volatile Duration rateLimitGroupStaleDuration;
    private final ConcurrentMap<String, Consumer<Integer>> queueCapacityCallbacks = new ConcurrentHashMap<String, Consumer<Integer>>();

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(TASK_QUEUE_CAPACITY_SETTING, TASK_POLL_FREQUENCY_SETTING, RATE_LIMIT_GROUP_CLEANUP_INTERVAL_SETTING, RATE_LIMIT_GROUP_STALE_DURATION_SETTING);
    }

    public RequestExecutorServiceSettings(Settings settings, ClusterService clusterService) {
        this.queueCapacity = (Integer)TASK_QUEUE_CAPACITY_SETTING.get(settings);
        this.taskPollFrequency = (TimeValue)TASK_POLL_FREQUENCY_SETTING.get(settings);
        this.setRateLimitGroupStaleDuration((TimeValue)RATE_LIMIT_GROUP_STALE_DURATION_SETTING.get(settings));
        this.addSettingsUpdateConsumers(clusterService);
    }

    private void addSettingsUpdateConsumers(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TASK_QUEUE_CAPACITY_SETTING, this::setQueueCapacity);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TASK_POLL_FREQUENCY_SETTING, this::setTaskPollFrequency);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RATE_LIMIT_GROUP_STALE_DURATION_SETTING, this::setRateLimitGroupStaleDuration);
    }

    void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        for (Consumer callback : this.queueCapacityCallbacks.values()) {
            callback.accept(queueCapacity);
        }
    }

    private void setTaskPollFrequency(TimeValue taskPollFrequency) {
        this.taskPollFrequency = taskPollFrequency;
    }

    private void setRateLimitGroupStaleDuration(TimeValue staleDuration) {
        this.rateLimitGroupStaleDuration = RequestExecutorServiceSettings.toDuration(staleDuration);
    }

    private static Duration toDuration(TimeValue timeValue) {
        return Duration.of(timeValue.duration(), timeValue.timeUnit().toChronoUnit());
    }

    void registerQueueCapacityCallback(String id, Consumer<Integer> onChangeCapacityCallback) {
        this.queueCapacityCallbacks.put(id, onChangeCapacityCallback);
    }

    void deregisterQueueCapacityCallback(String id) {
        this.queueCapacityCallbacks.remove(id);
    }

    int getQueueCapacity() {
        return this.queueCapacity;
    }

    TimeValue getTaskPollFrequency() {
        return this.taskPollFrequency;
    }

    Duration getRateLimitGroupStaleDuration() {
        return this.rateLimitGroupStaleDuration;
    }
}

